% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbp3d_cpp_rd.r
\docType{class}
\name{gbp3q}
\alias{Rcpp_gbp3q}
\alias{Rcpp_gbp3q-class}
\alias{gbp3q}
\title{gbp3q}
\format{An object of class \code{C++Class} of length 1.}
\usage{
gbp3q
}
\description{
generalized bin packing problem in 3 dimension, a.k.a bin packing problem.
}
\details{
gbp3d init a profit vector p, a length vector l, a depth vector d, a height vector h, and also
  a length constraint ml, a depth constraint md, and a height constraint mh on l x d x h cuboid
  with geometry intepretation.

 gbp3d solver would solve

   maximize   sum_{j=1}^{n} p_{j} k_{j}

   subject to fit (l_{j}, d_{j}, h_{j}) at coordinate (x_{j}, y_{j}, z_{j})
              such that no overlap in ml x md x mh cuboid, j = 1, ......, n

 and instantiate a gbp3d object with a x-axis coordinate vector x, a y-axis coordinate vector y,
  a z-axis coordinate vector z, a selection vector k, and an objective o.

 gbp3q solver would also select the most preferred often smallest m from a list of m(l, d, h) after
  determine all or the higest volume set of ld can fit into one m(l, d, h).

 a gbp3q class instance has 7 fields:

  - p: profit of it fit into bn <vector>

       created via cluster max(l, d, h) and area via gbp3d_solver_dpp_main_create_p()

  - it: it position and scale <matrix>

    - x, y, z it position in the bin <numeric>

    - l, d, h it scale along x, y, z <numeric>

  - bn: bn scale <matrix>

    - l, d, h bn scale along x, y, z <numeric>

      matrix of 3 rows and each column is a single bn

    should make sure bn list are sorted via volume
     so that the first col is the most prefered smallest bn, and also
     the last col is the least prefered largest and often dominant bn

    should make sure no X in front of Y if bnX dominant bnY,
     bnX dominant bnY if all(X(l, d, h) > Y(l, d, h)) and should always prefer Y.

    should make sure bn such that l >= d or vice versa.

  - k: selection indicator 0, 1 on it <vector>

  - f: selection indicator 0, 1, 2, 3 on bn <vector>

       f in result should have no 0 and only one of 1

  - o: objective achivement volumn fit in over volumn overall <numeric>

  - ok: a quick indicator of all it fit into bn? <bool>
}
\seealso{
Other gbp3q: \code{\link{gbp3d_solver_dpp_filt}},
  \code{\link{gbp3q_checkr}}
}
\keyword{datasets}

