% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constr.R
\name{gena.constr}
\alias{gena.constr}
\title{Constraints}
\usage{
gena.constr(population, method = "bounds", par, iter)
}
\arguments{
\item{population}{numeric matrix which rows are chromosomes i.e. vectors of 
parameters values.}

\item{method}{method used to impose constraints.}

\item{par}{additional parameters to be passed depending on the \code{method}.}

\item{iter}{iteration number of the genetic algorithm.}
}
\value{
The function returns a list with the following elements:
\itemize{
\item \code{population} - matrix which rows are chromosomes after
constraints have been imposed.
\item \code{constr.ind} - matrix of logical values which (i, j)-th
elements equals \code{TRUE} (\code{FALSE} otherwise) if j-th jene of
i-th chromosome is a subject to constraint.
}
}
\description{
Impose constraints on chromosomes.
}
\details{
If \code{method = "bounds"} then chromosomes will be bounded
between \code{par$lower} and \code{par$upper}.
}
\examples{
# Randomly initialize population
set.seed(123)
population <- gena.population(pop.n = 10,
                              lower = c(-5, -5), 
                              upper = c(5, 5))
                           
# Impose lower and upper bounds constraints
pop.constr <- gena.constr(population, 
                          method = "bounds",
                          par = list(lower = c(-1, 2),
                                     upper = c(1, 5)))
print(pop.constr)

}
