% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slider_genlogis.R
\name{genlog_slider}
\alias{genlog_slider}
\title{Slider for generalized logistic}
\usage{
genlog_slider(data, return_var = NULL, mu_range = 10, skew = F)
}
\arguments{
\item{data}{vector of data to compare.}

\item{return_var}{a char string to name where parameters are assigned}

\item{mu_range}{a number to setup the minimum and maximum range value of the mu parameter}

\item{skew}{logical, if \code{TRUE}, a model with skewness should be used..}
}
\value{
The function plots a interactive graphic in RStudio Viewer panel. \cr
Also, the parameters \code{a, b, p} and \code{mu} can be returned to 
\code{return_var} if asked in the graphic.
}
\description{
Make a generalized logistic distribution slider to compare histogram with theoretical distribution
}
\details{
There is a small gear in the top left of the graphic where you can slide the parameters \code{@param a,b,p,mu}.
The used distribution for this package is given by: 
\deqn{f(x) = ((a + b*(1+p)*(abs(x-mu)^p))*exp(-(x-mu)*(a+b*(|x-mu|^p)))) / ((exp(-(x-mu)*(a + b* (|x-mu|^p)))+1)^2)}
If the density function is not printed it is not defined for these parameters. \cr 

For \code{skew = T} the model used is

The used distribution for is given by: 
\deqn{f(x) = 2*((a + b*(1+p)*(abs(x-mu)^p))*exp(-(x-mu)*(a+b*(abs(x-mu)^p))))/ 
   ((exp(-(x-mu)*(a + b* (abs(x-mu)^p)))+1)^2) *
   ((exp(-(skew*(x-mu))*(a+b*(abs(skew*(x-mu))^p)))+1)^(-1)) }#' for more information about the model (\code{help(dgenlog_sk)})
If the density function is not printed it is not defined for these parameters. \cr 

\code{help(dgenlog)} for parameters restrictions.\cr 

This function requires RStudio to run.
\cr
}
\examples{
\dontrun{
datas <- rgenlog(1000)
if (manipulate::isAvailable()) {
  genlog_slider(datas, return_var = 'parameters')
 }
}

}
\references{
Rathie, P. N. and Swamee, P. K (2006) \emph{On a new invertible generalized logistic distribution
approximation to normal distribution}, Technical Research Report in Statistics, 07/2006,
Dept. of Statistics, Univ. of Brasilia, Brasilia, Brazil.

Azzalini, A. (1985) \emph{A class of distributions which includes the normal ones}. Scandinavian Journal of Statistics.
}
\keyword{genlogis}
