% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kriging.R
\name{geo_fkf}
\alias{geo_fkf}
\title{Kriging method for Spatial Functional Data.}
\usage{
geo_fkf(m_data, m_coord, new_loc, p, t = seq(from = -pi, to = pi, by = 0.01))
}
\arguments{
\item{m_data}{a tibble where each column or variable is data from a station}

\item{m_coord}{a tibble with two columns: latitude and longitude}

\item{new_loc}{a tible with one observation, where the columns or variables
are latitude and longitude}

\item{p}{order in the Fourier Polynomial}

\item{t}{a time series with values belonging to \eqn{[-\pi, \pi]} to
evaluate the estimate curve}
}
\value{
a list with three entries: \code{estimates}, \code{Theta} and
\code{cov_params}
\describe{
\item{estimates}{the estimate curve}
\item{Theta}{weights (matrices) of the linear combination}
\item{cov_params}{estimate \eqn{\sigma^2}, \eqn{\phi} and \eqn{\rho}}
}
}
\description{
\code{geo_fkf} implements the kriging method for spatial functional datasets.
}
\examples{
data("datasetCanada")

m_data <- as.matrix(datasetCanada$m_data)
m_coord <- as.matrix(datasetCanada$m_coord[, 1:2])
pos <- sample.int(nrow(m_coord), 1)
log_pos <- !(seq_len(nrow(m_coord)) \%in\% pos)
new_loc <- m_coord[pos, ]
m_coord <- m_coord[log_pos, ]
m_data <- m_data[, log_pos]

geo_fkf(m_data, m_coord, new_loc)
}
