% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcFGCMBelongMatrixNoisy}
\alias{calcFGCMBelongMatrixNoisy}
\title{Calculate the generalized membership matrix with a noise cluster}
\usage{
calcFGCMBelongMatrixNoisy(centers, data, m, beta, delta, sigmas)
}
\arguments{
\item{centers}{A matrix representing the centers of the
clusters with p columns and k rows}

\item{data}{A matrix representing the observed data with n rows
and p columns}

\item{m}{A float representing the fuzziness degree}

\item{beta}{A float for the beta parameter (control speed convergence and classification crispness)}

\item{delta}{A float, the value set for delta by the user}

\item{sigmas}{A numeric vector for calculating the robust version of the FCM. Filled with ones
if the classical version is required}
}
\value{
A n * k matrix representing the belonging probabilities of each
  observation to each cluster
}
\description{
Calculate the generalized membership matrix according to a set of
centroids, the observed data, the fuzziness degree, and a beta parameter
}
\keyword{internal}
