% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{standardizer}
\alias{standardizer}
\title{Standardizing helper}
\usage{
standardizer(x)
}
\arguments{
\item{x}{a numeric vector or a data.frame with only numeric columns.
Non numeric columns are dropped.}
}
\value{
If x was a vector, the function returns a list containing two
functions : scale and unscale. The first one is an equivalent of the
classical function scale(x, center = TRUE, scale = TRUE). The second
can be used to reverse the scaling and get back original units. If x
was a data.frame, the same pair of functions is returned inside of
a list for each numeric column.
}
\description{
Create functions to standardize and unstandardize data
}
\examples{
data(LyonIris)
LyonScales <- standardizer(sf::st_drop_geometry(LyonIris))
}
