#' Geo Grids
#'
#' @name grids
#' @docType data
#' @keywords data
#' @description There are now 216 grids available in this package and more online. To view a full list of available grids, see [here](https://raw.githubusercontent.com/hafen/grid-designer/master/grid_list.json). To create and submit your own grid, see [here](https://hafen.github.io/grid-designer/). To see several examples of grids being used to visualize data, see \code{\link{facet_geo}}.
#' @rdname grids
#' @md
NULL

#' @name us_state_grid1
#' @description
#' * **us_state_grid1:** Grid layout for US states (including DC).
#' @usage us_state_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid2
#' @description
#' * **us_state_grid2:** Grid layout for US states (including DC).
#' @usage us_state_grid2
#' @rdname grids
#' @md
NULL

#' @name eu_grid1
#' @description
#' * **eu_grid1:** Grid layout for the 28 EU Countries.
#' @usage eu_grid1
#' @rdname grids
#' @md
NULL

#' @name aus_grid1
#' @description
#' * **aus_grid1:** Grid layout for the Australian States and Territories.. Thanks to jonocarroll.
#' @usage aus_grid1
#' @rdname grids
#' @md
NULL

#' @name sa_prov_grid1
#' @description
#' * **sa_prov_grid1:** Grid layout for the provinces of South Africa. Thanks to jonmcalder.
#' @usage sa_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name gb_london_boroughs_grid
#' @description
#' * **gb_london_boroughs_grid:** Grid layout for the boroughs of London. Note that the column \code{code_ons} contains the codes used by UK Office for National Statistics.. Thanks to eldenvo.
#' @usage gb_london_boroughs_grid
#' @rdname grids
#' @md
NULL

#' @name nhs_scot_grid
#' @description
#' * **nhs_scot_grid:** Grid layout for a grid of NHS Scotland Health Boards. Note that the column \code{code} contains the codes used by UK Office for National Statistics.. Thanks to jsphdms.
#' @usage nhs_scot_grid
#' @rdname grids
#' @md
NULL

#' @name india_grid1
#' @description
#' * **india_grid1:** Grid layout for India states (not including union territories).. Thanks to meysubb.
#' @usage india_grid1
#' @rdname grids
#' @md
NULL

#' @name india_grid2
#' @description
#' * **india_grid2:** Grid layout for India states (not including union territories)..
#' @usage india_grid2
#' @rdname grids
#' @md
NULL

#' @name argentina_grid1
#' @description
#' * **argentina_grid1:** Grid for the 23 provinces of Argentina. It includes the Malvinas/Falkland Islands and the Antarctic Territories (these are disputed, but they are included since many researchers might use data from these locations).. Thanks to eliocamp.
#' @usage argentina_grid1
#' @rdname grids
#' @md
NULL

#' @name br_states_grid1
#' @description
#' * **br_states_grid1:** Grid for the 27 states of Brazil.. Thanks to italocegatta.
#' @usage br_states_grid1
#' @rdname grids
#' @md
NULL

#' @name sea_grid1
#' @description
#' * **sea_grid1:** Grid for South East Asian countries.. Thanks to jasonjb82.
#' @usage sea_grid1
#' @rdname grids
#' @md
NULL

#' @name mys_grid1
#' @description
#' * **mys_grid1:** Grid for Malaysian states and territories.. Thanks to jasonjb82.
#' @usage mys_grid1
#' @rdname grids
#' @md
NULL

#' @name fr_regions_grid1
#' @description
#' * **fr_regions_grid1:** Land and overseas regions of France. Codes are INSEE codes.. Thanks to mtmx.
#' @usage fr_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name de_states_grid1
#' @description
#' * **de_states_grid1:** Grid for the German states ('Länder'). Thanks to DominikVogel.
#' @usage de_states_grid1
#' @rdname grids
#' @md
NULL

#' @name us_or_counties_grid1
#' @description
#' * **us_or_counties_grid1:** Grid for Oregon counties.. Thanks to aosmith16.
#' @usage us_or_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_wa_counties_grid1
#' @description
#' * **us_wa_counties_grid1:** Grid for Washington counties..
#' @usage us_wa_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_in_counties_grid1
#' @description
#' * **us_in_counties_grid1:** Grid for Indiana counties.. Thanks to nateapathy.
#' @usage us_in_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_in_central_counties_grid1
#' @description
#' * **us_in_central_counties_grid1:** Grid for central Indiana counties.. Thanks to nateapathy.
#' @usage us_in_central_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name se_counties_grid1
#' @description
#' * **se_counties_grid1:** Grid for counties of Sweden.. Thanks to duleise.
#' @usage se_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name sf_bay_area_counties_grid1
#' @description
#' * **sf_bay_area_counties_grid1:** Grid of the 9 San Francisco Bay Area counties.. Thanks to Eunoia.
#' @usage sf_bay_area_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ua_region_grid1
#' @description
#' * **ua_region_grid1:** Grid of administrative divisions of Ukraine (24 oblasts, one autonomous region, and two cities).. Thanks to woldemarg.
#' @usage ua_region_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid1
#' @description
#' * **mx_state_grid1:** Grid layout for the states of Mexico.. Thanks to ikashnitsky.
#' @usage mx_state_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid2
#' @description
#' * **mx_state_grid2:** Grid layout for the states of Mexico.. Thanks to diegovalle.
#' @usage mx_state_grid2
#' @rdname grids
#' @md
NULL

#' @name scotland_local_authority_grid1
#' @description
#' * **scotland_local_authority_grid1:** Grid layout for the local authorities of Scotland.. Thanks to davidhen.
#' @usage scotland_local_authority_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_without_DC_grid1
#' @description
#' * **us_state_without_DC_grid1:** Grid layout for US states (excluding DC). Thanks to ejr248.
#' @usage us_state_without_DC_grid1
#' @rdname grids
#' @md
NULL

#' @name italy_grid1
#' @description
#' * **italy_grid1:** Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle).. Thanks to JulianStander.
#' @usage italy_grid1
#' @rdname grids
#' @md
NULL

#' @name italy_grid2
#' @description
#' * **italy_grid2:** Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle).. Thanks to JulianStander.
#' @usage italy_grid2
#' @rdname grids
#' @md
NULL

#' @name be_province_grid1
#' @description
#' * **be_province_grid1:** Grid layout for provinces of Belgium plus Brussels, including names in three languages (French, Dutch, English) and Belgium internal codes (NIS).. Thanks to ericlecoutre.
#' @usage be_province_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid3
#' @description
#' * **us_state_grid3:** Grid layout for US states (including DC).. Thanks to kanishkamisra.
#' @usage us_state_grid3
#' @rdname grids
#' @md
NULL

#' @name jp_prefs_grid1
#' @description
#' * **jp_prefs_grid1:** Grid layout for the prefectures of Japan.. Thanks to uribo.
#' @usage jp_prefs_grid1
#' @rdname grids
#' @md
NULL

#' @name ng_state_grid1
#' @description
#' * **ng_state_grid1:** Grid layout for the 37 Federal States of Nigeria.. Thanks to aledemogr.
#' @usage ng_state_grid1
#' @rdname grids
#' @md
NULL

#' @name bd_upazila_grid1
#' @description
#' * **bd_upazila_grid1:** Grid layout for Bangladesh 64 Upazilas.. Thanks to aledemogr.
#' @usage bd_upazila_grid1
#' @rdname grids
#' @md
NULL

#' @name spain_prov_grid1
#' @description
#' * **spain_prov_grid1:** Grid layout for Provinces of Spain.. Thanks to kintero.
#' @usage spain_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_cantons_grid1
#' @description
#' * **ch_cantons_grid1:** Grid layout for Cantons of Switzerland.. Thanks to tinu-schneider.
#' @usage ch_cantons_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_cantons_grid2
#' @description
#' * **ch_cantons_grid2:** Grid layout for Cantons of Switzerland.. Thanks to rastrau.
#' @usage ch_cantons_grid2
#' @rdname grids
#' @md
NULL

#' @name china_prov_grid1
#' @description
#' * **china_prov_grid1:** Grid layout for Provinces of China.. Thanks to weiyunna.
#' @usage china_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name world_86countries_grid
#' @description
#' * **world_86countries_grid:** Grid layout for 86 countries in the world.. Thanks to akangsha.
#' @usage world_86countries_grid
#' @rdname grids
#' @md
NULL

#' @name se_counties_grid2
#' @description
#' * **se_counties_grid2:** Grid for counties of Sweden.. Thanks to richardohrvall.
#' @usage se_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name uk_regions1
#' @description
#' * **uk_regions1:** Grid for regions of the UK (aka EU standard NUTS 1 areas).. Thanks to paulb20.
#' @usage uk_regions1
#' @rdname grids
#' @md
NULL

#' @name us_state_contiguous_grid1
#' @description
#' * **us_state_contiguous_grid1:** Grid layout for the contiguous US states (including DC).. Thanks to andrewsr.
#' @usage us_state_contiguous_grid1
#' @rdname grids
#' @md
NULL

#' @name sk_province_grid1
#' @description
#' * **sk_province_grid1:** Grid layout for South Korean sis and dos (metropolitan/special/autonomous cities and provinces).. Thanks to heon131.
#' @usage sk_province_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_aargau_districts_grid1
#' @description
#' * **ch_aargau_districts_grid1:** Grid layout for Districts of the Canton of Aargau, Switzerland.. Thanks to zumbov2.
#' @usage ch_aargau_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name jo_gov_grid1
#' @description
#' * **jo_gov_grid1:** Grid layout for Governorates of Jordan.. Thanks to aledemogr.
#' @usage jo_gov_grid1
#' @rdname grids
#' @md
NULL

#' @name es_autonomous_communities_grid1
#' @description
#' * **es_autonomous_communities_grid1:** Grid layout for Spanish 'Comunidades Autónomas'.. Thanks to JoseAntonioOrtega.
#' @usage es_autonomous_communities_grid1
#' @rdname grids
#' @md
NULL

#' @name spain_prov_grid2
#' @description
#' * **spain_prov_grid2:** Grid layout for Provinces of Spain.. Thanks to JoseAntonioOrtega.
#' @usage spain_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name world_countries_grid1
#' @description
#' * **world_countries_grid1:** Grid layout for countries of the world, with a few exclusions. See .. Thanks to JoseAntonioOrtega.
#' @usage world_countries_grid1
#' @rdname grids
#' @md
NULL

#' @name br_states_grid2
#' @description
#' * **br_states_grid2:** Grid for the 27 states of Brazil.. Thanks to hafen.
#' @usage br_states_grid2
#' @rdname grids
#' @md
NULL

#' @name china_city_grid1
#' @description
#' * **china_city_grid1:** Grid layout of cities in China.. Thanks to CharleneDeng1.
#' @usage china_city_grid1
#' @rdname grids
#' @md
NULL

#' @name kr_seoul_district_grid1
#' @description
#' * **kr_seoul_district_grid1:** Grid layout of Seoul's 25 districts.. Thanks to yonghah.
#' @usage kr_seoul_district_grid1
#' @rdname grids
#' @md
NULL

#' @name nz_regions_grid1
#' @description
#' * **nz_regions_grid1:** Grid layout for regions of New Zealand.. Thanks to pierreroudier.
#' @usage nz_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name sl_regions_grid1
#' @description
#' * **sl_regions_grid1:** Grid layout of Slovenian regions.. Thanks to SR1986.
#' @usage sl_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name us_census_div_grid1
#' @description
#' * **us_census_div_grid1:** Grid layout of US Census divisions.. Thanks to mkiang.
#' @usage us_census_div_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_tucuman_province_grid1
#' @description
#' * **ar_tucuman_province_grid1:** Grid layout for Argentina Tucumán Province political divisions (departments). Thanks to TuQmano.
#' @usage ar_tucuman_province_grid1
#' @rdname grids
#' @md
NULL

#' @name us_nh_counties_grid1
#' @description
#' * **us_nh_counties_grid1:** Grid layout for the 10 counties in New Hampshire.. Thanks to ghost.
#' @usage us_nh_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name china_prov_grid2
#' @description
#' * **china_prov_grid2:** Grid layout for Provinces of China.. Thanks to jw2531.
#' @usage china_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name pl_voivodeships_grid1
#' @description
#' * **pl_voivodeships_grid1:** Grid layout for Polish voivodeships (provinces). Thanks to erzk.
#' @usage pl_voivodeships_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ia_counties_grid1
#' @description
#' * **us_ia_counties_grid1:** Grid layout for counties in Iowa. Thanks to jrennyb.
#' @usage us_ia_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_id_counties_grid1
#' @description
#' * **us_id_counties_grid1:** Grid layout for counties in Idaho. Thanks to hathawayj.
#' @usage us_id_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_cordoba_dep_grid1
#' @description
#' * **ar_cordoba_dep_grid1:** Grid layout for departments of Cordoba province in Argentina.. Thanks to TuQmano.
#' @usage ar_cordoba_dep_grid1
#' @rdname grids
#' @md
NULL

#' @name us_fl_counties_grid1
#' @description
#' * **us_fl_counties_grid1:** Grid for Florida counties.. Thanks to ejr248.
#' @usage us_fl_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_buenosaires_communes_grid1
#' @description
#' * **ar_buenosaires_communes_grid1:** Grid for communes of Buenos Aires, Argentina.. Thanks to TuQmano.
#' @usage ar_buenosaires_communes_grid1
#' @rdname grids
#' @md
NULL

#' @name nz_regions_grid2
#' @description
#' * **nz_regions_grid2:** Grid layout for regions of New Zealand.. Thanks to pierreroudier.
#' @usage nz_regions_grid2
#' @rdname grids
#' @md
NULL

#' @name oecd_grid1
#' @description
#' * **oecd_grid1:** Grid layout for OECD member countries.. Thanks to arcruz0.
#' @usage oecd_grid1
#' @rdname grids
#' @md
NULL

#' @name ec_prov_grid1
#' @description
#' * **ec_prov_grid1:** Grid layout for provinces of Ecuador. Thanks to Ricardo95RM.
#' @usage ec_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name nl_prov_grid1
#' @description
#' * **nl_prov_grid1:** Grid layout for provinces of Netherlands. Thanks to ruditurksema.
#' @usage nl_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ca_prov_grid1
#' @description
#' * **ca_prov_grid1:** Grid layout for provinces of Canada. Thanks to michael-chong.
#' @usage ca_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name us_nc_counties_grid1
#' @description
#' * **us_nc_counties_grid1:** Grid layout for Counties of North Carolina, United States. Thanks to mtdukes.
#' @usage us_nc_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_ciudad_prov_grid1
#' @description
#' * **mx_ciudad_prov_grid1:** Grid layout for Districts of Mexico City, Mexico. Thanks to Ivangea.
#' @usage mx_ciudad_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name bg_prov_grid1
#' @description
#' * **bg_prov_grid1:** Grid layout for provinces of Bulgaria. Thanks to savinastoitsova.
#' @usage bg_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name us_hhs_regions_grid1
#' @description
#' * **us_hhs_regions_grid1:** This grid approximates the U.S. Health and Human Services Region map. Thanks to akitepowell.
#' @usage us_hhs_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name tw_counties_grid1
#' @description
#' * **tw_counties_grid1:** Grid layout for Counties of Taiwan. Thanks to csh484912274.
#' @usage tw_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name tw_counties_grid2
#' @description
#' * **tw_counties_grid2:** Grid layout for Counties of Taiwan including Lienchiang County. Thanks to csh484912274.
#' @usage tw_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name af_prov_grid1
#' @description
#' * **af_prov_grid1:** Grid layout for Provinces of Afghanistan. Thanks to jrennyb.
#' @usage af_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name us_mi_counties_grid1
#' @description
#' * **us_mi_counties_grid1:** Grid layout for Counties of Michigan, United States. Thanks to jrennyb.
#' @usage us_mi_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name pe_prov_grid1
#' @description
#' * **pe_prov_grid1:** Grid layout for Provinces of Peru. Thanks to jmcastagnetto.
#' @usage pe_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name sa_prov_grid2
#' @description
#' * **sa_prov_grid2:** Grid layout for Provinces of South Africa. Thanks to kamermanpr.
#' @usage sa_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid3
#' @description
#' * **mx_state_grid3:** Grid layout for States of Mexico. Thanks to ikashnitsky.
#' @usage mx_state_grid3
#' @rdname grids
#' @md
NULL

#' @name cn_bj_districts_grid1
#' @description
#' * **cn_bj_districts_grid1:** Grids for Administrative Districts of Beijing, China. Thanks to shiedelweiss.
#' @usage cn_bj_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name us_va_counties_grid1
#' @description
#' * **us_va_counties_grid1:** Grids for Counties of Virginia, United States. Thanks to joshyazman.
#' @usage us_va_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_mo_counties_grid1
#' @description
#' * **us_mo_counties_grid1:** Grids for Counties of Missouri, United States. Thanks to Yanqi-Xu.
#' @usage us_mo_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name cl_santiago_prov_grid1
#' @description
#' * **cl_santiago_prov_grid1:** Communes of Santiago Province, Chile. Thanks to robsalasco.
#' @usage cl_santiago_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name us_tx_capcog_counties_grid1
#' @description
#' * **us_tx_capcog_counties_grid1:** This is a grid of a 10 county planning region around Austin, Texas, United States. Thanks to mth444.
#' @usage us_tx_capcog_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name sg_planning_area_grid1
#' @description
#' * **sg_planning_area_grid1:** Grids for Planning Areas of Singapore. Thanks to Elenafuyi.
#' @usage sg_planning_area_grid1
#' @rdname grids
#' @md
NULL

#' @name in_state_ut_grid1
#' @description
#' * **in_state_ut_grid1:** Grid of Indian States and Union Territories. Thanks to seanangio.
#' @usage in_state_ut_grid1
#' @rdname grids
#' @md
NULL

#' @name cn_fujian_prov_grid1
#' @description
#' * **cn_fujian_prov_grid1:** Grid of counties of Fujian Province, China. Thanks to nannanchen333.
#' @usage cn_fujian_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ca_quebec_electoral_districts_grid1
#' @description
#' * **ca_quebec_electoral_districts_grid1:** Grid of Electoral Districts of Québec, Canada. Thanks to jhroy.
#' @usage ca_quebec_electoral_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name nl_prov_grid2
#' @description
#' * **nl_prov_grid2:** Grid with the provinces of The Netherlands with codes that are used by the statistical institute of NL. Thanks to edwindj.
#' @usage nl_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name cn_bj_districts_grid2
#' @description
#' * **cn_bj_districts_grid2:** Grid with districts of Beijing, China. Thanks to zouhx11.
#' @usage cn_bj_districts_grid2
#' @rdname grids
#' @md
NULL

#' @name ar_santiago_del_estero_prov_grid1
#' @description
#' * **ar_santiago_del_estero_prov_grid1:** Grid with districts of Santiago del Estero Province, Argentina. Thanks to TuQmano.
#' @usage ar_santiago_del_estero_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_formosa_prov_grid1
#' @description
#' * **ar_formosa_prov_grid1:** Grid with districts of Formosa Province, Argentina. Thanks to TuQmano.
#' @usage ar_formosa_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_chaco_prov_grid1
#' @description
#' * **ar_chaco_prov_grid1:** Grid with districts of Chaco Province, Argentina. Thanks to TuQmano.
#' @usage ar_chaco_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_catamarca_prov_grid1
#' @description
#' * **ar_catamarca_prov_grid1:** Grid with districts of Catamarca Province, Argentina. Thanks to TuQmano.
#' @usage ar_catamarca_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_jujuy_prov_grid1
#' @description
#' * **ar_jujuy_prov_grid1:** Grid with districts of Jujuy Province, Argentina. Thanks to TuQmano.
#' @usage ar_jujuy_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_neuquen_prov_grid1
#' @description
#' * **ar_neuquen_prov_grid1:** Grid with districts of Neuquen Province, Argentina. Thanks to TuQmano.
#' @usage ar_neuquen_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_san_luis_prov_grid1
#' @description
#' * **ar_san_luis_prov_grid1:** Grid with districts of San Luis Province, Argentina. Thanks to TuQmano.
#' @usage ar_san_luis_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_san_juan_prov_grid1
#' @description
#' * **ar_san_juan_prov_grid1:** Grid with districts of San Juan Province, Argentina. Thanks to TuQmano.
#' @usage ar_san_juan_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_santa_fe_prov_grid1
#' @description
#' * **ar_santa_fe_prov_grid1:** Grid with districts of Santa Fe Province, Argentina. Thanks to TuQmano.
#' @usage ar_santa_fe_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_la_rioja_prov_grid1
#' @description
#' * **ar_la_rioja_prov_grid1:** Grid with districts of La Rioja Province, Argentina. Thanks to TuQmano.
#' @usage ar_la_rioja_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_mendoza_prov_grid1
#' @description
#' * **ar_mendoza_prov_grid1:** Grid with districts of Mendoza Province, Argentina. Thanks to TuQmano.
#' @usage ar_mendoza_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_salta_prov_grid1
#' @description
#' * **ar_salta_prov_grid1:** Grid with districts of Salta Province, Argentina. Thanks to TuQmano.
#' @usage ar_salta_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_rio_negro_prov_grid1
#' @description
#' * **ar_rio_negro_prov_grid1:** Grid with districts of Rio Negro Province, Argentina. Thanks to TuQmano.
#' @usage ar_rio_negro_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name uy_departamentos_grid1
#' @description
#' * **uy_departamentos_grid1:** Grid with Departamentos of Uruguay. Thanks to TuQmano.
#' @usage uy_departamentos_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_buenos_aires_prov_electoral_dist_grid1
#' @description
#' * **ar_buenos_aires_prov_electoral_dist_grid1:** Grid with Electoral Districts of Buenos Aires Province, Argentina. Thanks to TuQmano.
#' @usage ar_buenos_aires_prov_electoral_dist_grid1
#' @rdname grids
#' @md
NULL

#' @name europe_countries_grid1
#' @description
#' * **europe_countries_grid1:** Grid layout for all European countries except Vatican City, Monaco, San Marino and Liechtenstein. Thanks to THargreaves.
#' @usage europe_countries_grid1
#' @rdname grids
#' @md
NULL

#' @name argentina_grid2
#' @description
#' * **argentina_grid2:** Grid layout for Argentina without Islas Malvinas and Antártida Argentina. Thanks to TuQmano.
#' @usage argentina_grid2
#' @rdname grids
#' @md
NULL

#' @name us_state_without_DC_grid2
#' @description
#' * **us_state_without_DC_grid2:** Grid layout for United States with AK and HI flush with CA. Thanks to christophercannon.
#' @usage us_state_without_DC_grid2
#' @rdname grids
#' @md
NULL

#' @name jp_prefs_grid2
#' @description
#' * **jp_prefs_grid2:** Grid layout for Prefectures of Japan. Thanks to Ryo-N7.
#' @usage jp_prefs_grid2
#' @rdname grids
#' @md
NULL

#' @name na_regions_grid1
#' @description
#' * **na_regions_grid1:** Regions of Namibia. Thanks to stedy.
#' @usage na_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name mm_state_grid1
#' @description
#' * **mm_state_grid1:** States of Myanmar. Thanks to htinkyawaye.
#' @usage mm_state_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_with_DC_PR_grid1
#' @description
#' * **us_state_with_DC_PR_grid1:** United States of America including Washington, D.C. and Puerto Rico. Thanks to krothkin.
#' @usage us_state_with_DC_PR_grid1
#' @rdname grids
#' @md
NULL

#' @name fr_departements_grid1
#' @description
#' * **fr_departements_grid1:** Grid for France's departements, the second levels of administrative boundaries after the regions. Thanks to tvroylandt.
#' @usage fr_departements_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_salta_prov_grid2
#' @description
#' * **ar_salta_prov_grid2:** Grids for Salta Province Argentina. Thanks to tartagalensis.
#' @usage ar_salta_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name ie_counties_grid1
#' @description
#' * **ie_counties_grid1:** Ireland counties. Code is the car number plate abbreviation for Republic counties, similar for the six counties of Northern Ireland. Tipperary is split North / South for historical reasons. Thanks to eugene100hickey.
#' @usage ie_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name sg_regions_grid1
#' @description
#' * **sg_regions_grid1:** Urban planning regions of Singapore. Thanks to erhuttk.
#' @usage sg_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ny_counties_grid1
#' @description
#' * **us_ny_counties_grid1:** Counties of New York State, United States. Thanks to jjdfsny.
#' @usage us_ny_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ru_federal_subjects_grid1
#' @description
#' * **ru_federal_subjects_grid1:** Federal Subjects of Russia. Thanks to ParanoidAndroid18.
#' @usage ru_federal_subjects_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ca_counties_grid1
#' @description
#' * **us_ca_counties_grid1:** Counties of the State of California, United States. Thanks to MartinLe5.
#' @usage us_ca_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name lk_districts_grid1
#' @description
#' * **lk_districts_grid1:** Second level administrative divisions of Sri Lanka. Thanks to thiyangt.
#' @usage lk_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_without_DC_grid3
#' @description
#' * **us_state_without_DC_grid3:** United States grid without Washington, D.C. Thanks to ghost.
#' @usage us_state_without_DC_grid3
#' @rdname grids
#' @md
NULL

#' @name co_cali_subdivisions_grid1
#' @description
#' * **co_cali_subdivisions_grid1:** Corregimientos of Cali, Columbia. Thanks to Carolina101.
#' @usage co_cali_subdivisions_grid1
#' @rdname grids
#' @md
NULL

#' @name us_in_northern_counties_grid1
#' @description
#' * **us_in_northern_counties_grid1:** Northern Counties of Indiana, United States. Thanks to robertoge.
#' @usage us_in_northern_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name italy_grid3
#' @description
#' * **italy_grid3:** Autonomous Provinces of Italy. Thanks to danilolofaro.
#' @usage italy_grid3
#' @rdname grids
#' @md
NULL

#' @name us_state_with_DC_PR_grid2
#' @description
#' * **us_state_with_DC_PR_grid2:** Grid of 50 states, DC, and Puerto Rico. Thanks to krmaas.
#' @usage us_state_with_DC_PR_grid2
#' @rdname grids
#' @md
NULL

#' @name us_state_grid7
#' @description
#' * **us_state_grid7:** United States grid with Washington, D.C. Thanks to yichenqin.
#' @usage us_state_grid7
#' @rdname grids
#' @md
NULL

#' @name sg_planning_area_grid2
#' @description
#' * **sg_planning_area_grid2:** Singapore Planning Areas. Thanks to ZhimaoElliott.
#' @usage sg_planning_area_grid2
#' @rdname grids
#' @md
NULL

#' @name ch_cantons_fl_grid1
#' @description
#' * **ch_cantons_fl_grid1:** Grid layout for Cantons of Switzerland and the neighbouring Prinicipality of Liechtenstein. Thanks to rastrau.
#' @usage ch_cantons_fl_grid1
#' @rdname grids
#' @md
NULL

#' @name europe_countries_grid2
#' @description
#' * **europe_countries_grid2:** Grid layout for European countries (minus micro nations). Thanks to rastrau.
#' @usage europe_countries_grid2
#' @rdname grids
#' @md
NULL

#' @name us_states_territories_grid1
#' @description
#' * **us_states_territories_grid1:** Grid layout for U.S. states and territories. Thanks to rastrau.
#' @usage us_states_territories_grid1
#' @rdname grids
#' @md
NULL

#' @name us_tn_counties_grid1
#' @description
#' * **us_tn_counties_grid1:** Grid layout for counties of Tennesee, United States. Thanks to binkleym.
#' @usage us_tn_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_il_chicago_community_areas_grid1
#' @description
#' * **us_il_chicago_community_areas_grid1:** Grid layout for the Community Areas of Chicago. Thanks to leungkp.
#' @usage us_il_chicago_community_areas_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_with_DC_PR_grid3
#' @description
#' * **us_state_with_DC_PR_grid3:** United States grid with Washington, D.C. and Puerto Rico. Thanks to klittle314.
#' @usage us_state_with_DC_PR_grid3
#' @rdname grids
#' @md
NULL

#' @name in_state_ut_grid2
#' @description
#' * **in_state_ut_grid2:** Grid of Indian States and Union Territories. Thanks to dnyansagar.
#' @usage in_state_ut_grid2
#' @rdname grids
#' @md
NULL

#' @name at_states_grid1
#' @description
#' * **at_states_grid1:** Grid layout for States of Austria. Thanks to wkapga.
#' @usage at_states_grid1
#' @rdname grids
#' @md
NULL

#' @name us_pa_counties_grid1
#' @description
#' * **us_pa_counties_grid1:** Grid layout of Counties of Pennsylvania, United States. Thanks to urbanSpatial.
#' @usage us_pa_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_oh_counties_grid1
#' @description
#' * **us_oh_counties_grid1:** Grid layout of Counties of Ohio, United States. Thanks to taylorokonek.
#' @usage us_oh_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name fr_departements_grid2
#' @description
#' * **fr_departements_grid2:** Grid layout of Departements of France. Thanks to jerbou.
#' @usage fr_departements_grid2
#' @rdname grids
#' @md
NULL

#' @name us_wi_counties_grid1
#' @description
#' * **us_wi_counties_grid1:** Grid layout for counties of Wisconsin, United States. Thanks to aravamu2.
#' @usage us_wi_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name africa_countries_grid1
#' @description
#' * **africa_countries_grid1:** Grid for all countries in Africa. Namibia added as 'NAM' to avoid NA collisions. Thanks to ntncmch.
#' @usage africa_countries_grid1
#' @rdname grids
#' @md
NULL

#' @name no_counties_grid1
#' @description
#' * **no_counties_grid1:** Grid of counties of Norway. Thanks to NanAmalie1.
#' @usage no_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name tr_provinces_grid1
#' @description
#' * **tr_provinces_grid1:** Grid of Provinces of Turkey. Thanks to sadettindemirel.
#' @usage tr_provinces_grid1
#' @rdname grids
#' @md
NULL

#' @name us_eastern_states_grid1
#' @description
#' * **us_eastern_states_grid1:** US State_grid showing only the states for which some portion falls east of the 100th meridian. Thanks to mihiarc.
#' @usage us_eastern_states_grid1
#' @rdname grids
#' @md
NULL

#' @name br_states_grid3
#' @description
#' * **br_states_grid3:** Grid map of States of Brazil organized horizontally by region. Thanks to lzrmr.
#' @usage br_states_grid3
#' @rdname grids
#' @md
NULL

#' @name us_states_territories_grid2
#' @description
#' * **us_states_territories_grid2:** Grid map of US States and Territories. Thanks to edavidaja.
#' @usage us_states_territories_grid2
#' @rdname grids
#' @md
NULL

#' @name us_state_grid8
#' @description
#' * **us_state_grid8:** Grid map of US States including Washington, D.C.. Thanks to krothkin.
#' @usage us_state_grid8
#' @rdname grids
#' @md
NULL

#' @name us_state_grid9
#' @description
#' * **us_state_grid9:** Grid map of US States including Washington, D.C.. Thanks to krothkin.
#' @usage us_state_grid9
#' @rdname grids
#' @md
NULL

#' @name fr_departements_grid3
#' @description
#' * **fr_departements_grid3:** Grid of Departements of France. Thanks to leachareyre.
#' @usage fr_departements_grid3
#' @rdname grids
#' @md
NULL

#' @name in_state_ut_grid3
#' @description
#' * **in_state_ut_grid3:** Grid of Indian States and Union Territories. Thanks to aeschuma.
#' @usage in_state_ut_grid3
#' @rdname grids
#' @md
NULL

#' @name th_provinces_grid1
#' @description
#' * **th_provinces_grid1:** Grid of Provinces of Thailand. Thanks to PaulApivat.
#' @usage th_provinces_grid1
#' @rdname grids
#' @md
NULL

#' @name th_bangkok_districts_grid1
#' @description
#' * **th_bangkok_districts_grid1:** Grid of Districts of Bangkok, Thailand. Thanks to PaulApivat.
#' @usage th_bangkok_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name ca_us_prov_state_grid1
#' @description
#' * **ca_us_prov_state_grid1:** Grid of Provinces and States of Canada and US. Thanks to ahcyip.
#' @usage ca_us_prov_state_grid1
#' @rdname grids
#' @md
NULL

#' @name sy_governorates_grid1
#' @description
#' * **sy_governorates_grid1:** Grid of ADM-1 units (governorates) for Syria. Thanks to jschon637.
#' @usage sy_governorates_grid1
#' @rdname grids
#' @md
NULL

#' @name ro_counties_grid1
#' @description
#' * **ro_counties_grid1:** Grid of counties (județe) of Romania. Thanks to bogdanantonescu.
#' @usage ro_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_va_health_districts_grid1
#' @description
#' * **us_va_health_districts_grid1:** Grid of Commonwealth of Virginia's Health Districts. Thanks to osesusan.
#' @usage us_va_health_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_without_DC_canada_prov_grid1
#' @description
#' * **us_state_without_DC_canada_prov_grid1:** US States without DC with 10 Canadian Provinces. Thanks to opus1993.
#' @usage us_state_without_DC_canada_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ir_provinces_grid1
#' @description
#' * **ir_provinces_grid1:** Provinces of Iran. Thanks to mcnakhaee.
#' @usage ir_provinces_grid1
#' @rdname grids
#' @md
NULL

#' @name co_departments_grid1
#' @description
#' * **co_departments_grid1:** Departments of Colombia. Thanks to mikafui2020.
#' @usage co_departments_grid1
#' @rdname grids
#' @md
NULL

#' @name ir_tehran_districts_grid1
#' @description
#' * **ir_tehran_districts_grid1:** Grid for 22 districts in Tehran, Iran. Thanks to mcnakhaee.
#' @usage ir_tehran_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name ro_counties_grid2
#' @description
#' * **ro_counties_grid2:** Grid of Romanian Counties. Thanks to alexfg.
#' @usage ro_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name gb_sct_council_areas_grid1
#' @description
#' * **gb_sct_council_areas_grid1:** Council Areas of Scotland. Thanks to AndrewAiton.
#' @usage gb_sct_council_areas_grid1
#' @rdname grids
#' @md
NULL

#' @name mw_districts_grid1
#' @description
#' * **mw_districts_grid1:** Grid of 27 districts of Malawi (all districts other than Likoma, which is an island). Thanks to taylorokonek.
#' @usage mw_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name dk_cph_grid1
#' @description
#' * **dk_cph_grid1:** Grid of the 10 districts of Copenhagen, Denmark. Thanks to Straubinger.
#' @usage dk_cph_grid1
#' @rdname grids
#' @md
NULL

#' @name us_nv_counties_grid1
#' @description
#' * **us_nv_counties_grid1:** Counties of State of Nevada, United States. Thanks to schmidtDETR.
#' @usage us_nv_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ie_counties_grid2
#' @description
#' * **ie_counties_grid2:** Counties of Ireland. Thanks to cbhurley.
#' @usage ie_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name bo_departments_grid1
#' @description
#' * **bo_departments_grid1:** Grid of Departamental Political Division of Bolivia. Thanks to tartagalensis.
#' @usage bo_departments_grid1
#' @rdname grids
#' @md
NULL

#' @name ie_counties_grid3
#' @description
#' * **ie_counties_grid3:** Grid of 32 Counties of Ireland with Tipperary as one county. Thanks to superboreen.
#' @usage ie_counties_grid3
#' @rdname grids
#' @md
NULL

#' @name co_departments_grid2
#' @description
#' * **co_departments_grid2:** Grid of Departments of Colombia with municipal DANE codes. Thanks to sfanchi.
#' @usage co_departments_grid2
#' @rdname grids
#' @md
NULL

#' @name americas_countries_grid1
#' @description
#' * **americas_countries_grid1:** Map of countries of North and South America. Thanks to Aminsn.
#' @usage americas_countries_grid1
#' @rdname grids
#' @md
NULL

#' @name us_census_div_grid2
#' @description
#' * **us_census_div_grid2:** Geofacet grid for the cartographic boundary map of the four official US regions, according to the US Census Bureau. Thanks to AnneIoannides.
#' @usage us_census_div_grid2
#' @rdname grids
#' @md
NULL

#' @name ar_buenosaires_conurbano_grid1
#' @description
#' * **ar_buenosaires_conurbano_grid1:** Grids representing the greater Buenos Aires area which includes the autonomous city of Buenos Aires and some department/partidos of the Buenos Aires Province. Thanks to SantiagoEsteban.
#' @usage ar_buenosaires_conurbano_grid1
#' @rdname grids
#' @md
NULL

#' @name us_md_counties_grid1
#' @description
#' * **us_md_counties_grid1:** Counties of the State of Maryland, United States. Thanks to tecason.
#' @usage us_md_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ia_counties_grid2
#' @description
#' * **us_ia_counties_grid2:** Counties of the State of Iowa, United States. Thanks to tecason.
#' @usage us_ia_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name us_western_states_grid1
#' @description
#' * **us_western_states_grid1:** Grid of Western United States. Thanks to JHasselbeck.
#' @usage us_western_states_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ga_counties_grid1
#' @description
#' * **us_ga_counties_grid1:** Grid of Counties of Georgia, United States. Thanks to pjm407.
#' @usage us_ga_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ro_counties_grid3
#' @description
#' * **ro_counties_grid3:** Counties (Judete) of Romania. Thanks to vparvu.
#' @usage ro_counties_grid3
#' @rdname grids
#' @md
NULL

#' @name es_autonomous_communities_grid2
#' @description
#' * **es_autonomous_communities_grid2:** Autonomous Communities of Spain. Thanks to dieghernan.
#' @usage es_autonomous_communities_grid2
#' @rdname grids
#' @md
NULL

#' @name qa_municipalities_grid1
#' @description
#' * **qa_municipalities_grid1:** Municipalities of Qatar. Thanks to stedy.
#' @usage qa_municipalities_grid1
#' @rdname grids
#' @md
NULL

#' @name kz_region_grid1
#' @description
#' * **kz_region_grid1:** Regions of Kazakhstan. Thanks to Sofiya2809.
#' @usage kz_region_grid1
#' @rdname grids
#' @md
NULL

#' @name middle_east_grid1
#' @description
#' * **middle_east_grid1:** Countries of the Middle East with ISO codes. Thanks to anamartincalde.
#' @usage middle_east_grid1
#' @rdname grids
#' @md
NULL

#' @name cz_prague_districts_grid1
#' @description
#' * **cz_prague_districts_grid1:** Grid of the 57 city districts of the city of Prague, Czech Republic using RUIAN IDs. Thanks to petrbouchal.
#' @usage cz_prague_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name es_catalonia_comarques_grid1
#' @description
#' * **es_catalonia_comarques_grid1:** Grid of Comarques of Catalonia, Soain. Thanks to Storydata.
#' @usage es_catalonia_comarques_grid1
#' @rdname grids
#' @md
NULL

#' @name no_counties_grid2
#' @description
#' * **no_counties_grid2:** Counties of Norway in 2020. Thanks to LIVF.
#' @usage no_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name fi_helsinki_neighborhoods_grid1
#' @description
#' * **fi_helsinki_neighborhoods_grid1:** Neighborhoods of Helsinki, Finland. Thanks to msutela.
#' @usage fi_helsinki_neighborhoods_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_without_DC_AK_HI_grid1
#' @description
#' * **us_state_without_DC_AK_HI_grid1:** Updated US state Without DC, AK and HI. Thanks to KWB4484.
#' @usage us_state_without_DC_AK_HI_grid1
#' @rdname grids
#' @md
NULL

#' @name ru_federal_subjects_grid2
#' @description
#' * **ru_federal_subjects_grid2:** Federal Subjects of Russia. Thanks to katerinaalex.
#' @usage ru_federal_subjects_grid2
#' @rdname grids
#' @md
NULL

#' @name us_ut_counties_grid1
#' @description
#' * **us_ut_counties_grid1:** Grid of Counties of Utah, United States. Thanks to raogeorge.
#' @usage us_ut_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name in_state_ut_grid4
#' @description
#' * **in_state_ut_grid4:** India states and union territories facet grid. Changes compared to previous grid: now the following union territories are included as well: Chandigarh, Delhi, Lakshadweep, Andaman and Nicobar Islands, Ladakh.. Thanks to rishabhshah-92.
#' @usage in_state_ut_grid4
#' @rdname grids
#' @md
NULL

#' @name ec_prov_grid2
#' @description
#' * **ec_prov_grid2:** Denser grid for Provinces of Ecuador including Galápagos Islands. Thanks to temporalista.
#' @usage ec_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name es_prov_grid1
#' @description
#' * **es_prov_grid1:** Grid of Provinces of Spain. Thanks to EstebanAnd.
#' @usage es_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name americas_countries_grid2
#' @description
#' * **americas_countries_grid2:** Grid of Countries of North and South America. Thanks to MathildeMousset.
#' @usage americas_countries_grid2
#' @rdname grids
#' @md
NULL

#' @name us_nm_counties_grid1
#' @description
#' * **us_nm_counties_grid1:** Grid of Counties of New Mexico, United States. Thanks to ty-sanders.
#' @usage us_nm_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_me_counties_grid1
#' @description
#' * **us_me_counties_grid1:** Grid of Counties of Maine, United States. Thanks to dikbrown.
#' @usage us_me_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name cu_prov_grid1
#' @description
#' * **cu_prov_grid1:** Grid of Provinces of Cuba and Isla de la Juventud. Thanks to accostales.
#' @usage cu_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ge_regions_grid1
#' @description
#' * **ge_regions_grid1:** Grid of Regions of Georgia. Thanks to nasrashvilin.
#' @usage ge_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name co_departments_grid3
#' @description
#' * **co_departments_grid3:** Grid of Departments of Colombia. Thanks to JOTOR.
#' @usage co_departments_grid3
#' @rdname grids
#' @md
NULL

#' @name gb_london_boroughs_grid2
#' @description
#' * **gb_london_boroughs_grid2:** Boroughs of London with name wrapped to fit grid. Thanks to ICAITC.
#' @usage gb_london_boroughs_grid2
#' @rdname grids
#' @md
NULL

#' @name gb_sct_aberdeenshire_IZ_grid1
#' @description
#' * **gb_sct_aberdeenshire_IZ_grid1:** Grid of Scottish intermediate zones for Aberdeenshire. Thanks to waynegault.
#' @usage gb_sct_aberdeenshire_IZ_grid1
#' @rdname grids
#' @md
NULL

#' @name gb_sct_aberdeenshire_wards_grid1
#' @description
#' * **gb_sct_aberdeenshire_wards_grid1:** Grid of Aberdeenshire, Scotland's Multi-member Wards. Thanks to waynegault.
#' @usage gb_sct_aberdeenshire_wards_grid1
#' @rdname grids
#' @md
NULL

#' @name at_vienna_districts_grid1
#' @description
#' * **at_vienna_districts_grid1:** Districts of Vienna, Austria. Thanks to romanseidl.
#' @usage at_vienna_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name gh_regions_grid1
#' @description
#' * **gh_regions_grid1:** Regions of Ghana. Thanks to Abu-sakara.
#' @usage gh_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name uy_departamentos_grid2
#' @description
#' * **uy_departamentos_grid2:** Departamentos of Uruguay. Thanks to RichDeto.
#' @usage uy_departamentos_grid2
#' @rdname grids
#' @md
NULL

#' @name ch_vaud_districts_grid1
#' @description
#' * **ch_vaud_districts_grid1:** Districts for Canton of Vaud, Switzerland. Thanks to vdes2020.
#' @usage ch_vaud_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ca_counties_FIPS_grid1
#' @description
#' * **us_ca_counties_FIPS_grid1:** Grid of Counties of California, United States with FIPS codes. Thanks to ahcyip.
#' @usage us_ca_counties_FIPS_grid1
#' @rdname grids
#' @md
NULL

#' @name kr_seoul_district_grid2
#' @description
#' * **kr_seoul_district_grid2:** Grid of Districts of Seoul, South Korea. Thanks to kjhnav.
#' @usage kr_seoul_district_grid2
#' @rdname grids
#' @md
NULL

#' @name kr_districts_grid1
#' @description
#' * **kr_districts_grid1:** Administrative Districts of South Korea. Thanks to kjhnav.
#' @usage kr_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name oecd_grid2
#' @description
#' * **oecd_grid2:** Grid of member countries of Organisation for Economic Co-operation and Development. Thanks to kjhnav.
#' @usage oecd_grid2
#' @rdname grids
#' @md
NULL

#' @name bo_departments_grid2
#' @description
#' * **bo_departments_grid2:** Grid of Departamentos of Bolivia. Thanks to ccsuehara.
#' @usage bo_departments_grid2
#' @rdname grids
#' @md
NULL

#' @name ca_us_prov_state_grid2
#' @description
#' * **ca_us_prov_state_grid2:** Grid of Provinces of Canada and States of United States. Thanks to semerson77.
#' @usage ca_us_prov_state_grid2
#' @rdname grids
#' @md
NULL

#' @name us_il_counties_grid1
#' @description
#' * **us_il_counties_grid1:** Grid of Counties of Illinois, United States. Thanks to amsutton.
#' @usage us_il_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name tn_governorates_grid1
#' @description
#' * **tn_governorates_grid1:** Grid of Governorates of Tunisia. Thanks to AminGhrabi.
#' @usage tn_governorates_grid1
#' @rdname grids
#' @md
NULL

#' @name gb_sct_glasgow_wards_grid1
#' @description
#' * **gb_sct_glasgow_wards_grid1:** Electoral Wards of Glasgow, Scotland. Thanks to nrennie.
#' @usage gb_sct_glasgow_wards_grid1
#' @rdname grids
#' @md
NULL

#' @name kr_provinces_grid1
#' @description
#' * **kr_provinces_grid1:** Provinces of Republic of Korea. Thanks to statkclee.
#' @usage kr_provinces_grid1
#' @rdname grids
#' @md
NULL

#' @name kr_counties_districts_cities_grid1
#' @description
#' * **kr_counties_districts_cities_grid1:** South Korean metropolitan cities' districts (gu), municipal cities (si), and counties (gun). Thanks to chichead.
#' @usage kr_counties_districts_cities_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ok_counties_grid1
#' @description
#' * **us_ok_counties_grid1:** Grid of Counties of Oklahoma, United States. Thanks to andrewvanleuven.
#' @usage us_ok_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_dc_neighborhoods_grid1
#' @description
#' * **us_dc_neighborhoods_grid1:** Grid of Neighborhoods of District of Columbia, United States. Thanks to rexarski.
#' @usage us_dc_neighborhoods_grid1
#' @rdname grids
#' @md
NULL

#' @name us_mn_counties_grid1
#' @description
#' * **us_mn_counties_grid1:** Grid of Counties of Minnesota. Thanks to chadrent.
#' @usage us_mn_counties_grid1
#' @rdname grids
#' @md
NULL
