% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogc_api_nls.R
\name{ogc_get_maastotietokanta_collections}
\alias{ogc_get_maastotietokanta_collections}
\title{Fetch Maastotietokanta Collections}
\usage{
ogc_get_maastotietokanta_collections(api_key = getOption("geofi_mml_api_key"))
}
\arguments{
\item{api_key}{Character. \href{https://www.maanmittauslaitos.fi/en/rajapinnat/api-avaimen-ohje}{API key} for authenticating with the Maastotietokanta
OGC API. Defaults to the value stored in \code{options(geofi_mml_api_key)}.
You can obtain an API key from the Maanmittauslaitos (National Land Survey
of Finland) website.}
}
\value{
A data frame with two columns:
\itemize{
\item \code{id}: The title of each collection.
\item \code{description}: A brief description of each collection.
}
}
\description{
Retrieves a list of available collections from the Maastotietokanta (Topographic Database) OGC API,
including their titles and descriptions.
}
\details{
This function queries the Maastotietokanta OGC API to retrieve metadata about
available collections of spatial data. The API is provided by the National Land
Survey of Finland (Maanmittauslaitos). The function requires a valid API key,
which can be provided directly or set via \code{options(geofi_mml_api_key)}.

The function includes error handling:
\itemize{
\item It retries failed requests up to 3 times for transient network issues
or server errors (HTTP 500–599) with exponential backoff.
\item It handles rate limits (HTTP 429) by respecting the \code{Retry-After} header.
\item It validates the API response to ensure the expected data is present.
}
}
\examples{
\dontrun{
# Set your API key
options(geofi_mml_api_key = "your_api_key_here")

# Fetch the list of collections
collections <- ogc_get_maastotietokanta_collections()
print(collections)

# Alternatively, provide the API key directly
collections <- ogc_get_maastotietokanta_collections(api_key = "your_api_key_here")
print(collections)
}

}
\seealso{
\url{https://www.maanmittauslaitos.fi/en/rajapinnat/api-avaimen-ohje} for more information
on the Maastotietokanta OGC API and how to obtain an API key.
}
