% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{row_standardize}
\alias{row_standardize}
\title{Row-standardize a matrix; safe for zero row-sums.}
\usage{
row_standardize(C, warn = FALSE, msg = "Row standardizing connectivity matrix")
}
\arguments{
\item{C}{A matrix}

\item{warn}{Print message \code{msg} if \code{warn = TRUE}.}

\item{msg}{A warning message; used internally by geostan.}
}
\value{
A row-standardized matrix, W (i.e., all row sums equal 1, or zero).
}
\description{
Row-standardize a matrix; safe for zero row-sums.
}
\examples{
A <- shape2mat(georgia)
head(Matrix::summary(A))
Matrix::rowSums(A)

W <- row_standardize(A)
head(Matrix::summary(W))
Matrix::rowSums(W)

}
