% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-bagplot.r
\name{stat_bagplot}
\alias{stat_bagplot}
\title{Bagplots}
\usage{
stat_bagplot(
  mapping = NULL,
  data = NULL,
  geom = "bagplot",
  position = "identity",
  fraction = 0.5,
  coef = 3,
  median = TRUE,
  fence = TRUE,
  outliers = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{fraction}{Fraction of the data to include in the bag.}

\item{coef}{Scale factor of the fence relative to the bag.}

\item{median, fence, outliers}{Logical indicators whether to include median,
fence, and outliers in the composite output.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{
  Arguments passed on to \code{\link[=stat_depth]{stat_depth}}
  \describe{
    \item{\code{notion}}{Character; the name of the depth function (passed to
\code{\link[ddalpha:depth.]{ddalpha::depth.()}}).}
    \item{\code{notion_params}}{List of additional parameters passed via \code{...} to
\code{\link[ddalpha:depth.]{ddalpha::depth.()}}.}
  }}
}
\value{
A \link[=gggda-ggproto]{ggproto} \link[ggplot2:layer]{layer}.
}
\description{
Construct medians, bags, fences, and outlier specifications for
bagplots.
}
\details{
A bagplot comprises a single, often filled, depth contour (the
"bag") overlaid with the hull of its union with the data points contained
in its scaled expansion from the depth median (the "fence") and a
scatterplot of outliers beyond the fence (the "loop"). Rousseeuw &al (1999)
suggest the term "bag-and-bolster plot" evocative of the "box-and-whisker
plot".

While the depth median can be obtained using \code{\link[=stat_center]{stat_center()}}, the data
depth values used to compute it are also used to demarcate the bag, so it
is implemented separately in \code{StatBagplot$compute_group()} for efficiency.

\code{stat_bagplot()} is designed to pair with \code{\link[=geom_bagplot]{geom_bagplot()}}, analogously to
the pairing of \code{\link[ggplot2:geom_boxplot]{ggplot2::stat_boxplot()}} with \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}. In
particular, \code{GeomBagplot} is the only \code{ggproto} that recognizes the
computed variable \code{component}, used by \code{StatBagplot} to separate data for
the four bagplot elements.
}
\section{Multidimensional position aesthetics}{

This statistical transformation is compatible with the convenience function
\code{\link[=aes_coord]{aes_coord()}}.

Some transformations (e.g. \code{\link[=stat_center]{stat_center()}}) commute with projection to the
lower (1 or 2)-dimensional biplot space. If they detect aesthetics of the
form \verb{..coord[0-9]+}, then \code{..coord1} and \code{..coord2} are converted to \code{x} and
\code{y} while any remaining are ignored.

Other transformations (e.g. \code{\link[=stat_spantree]{stat_spantree()}}) yield different results in a
lower-dimensional biplot when they are computed before versus after
projection. If the stat layer detects these aesthetics, then the
transformation is performed before projection, and the results in the first
two dimensions are returned as \code{x} and \code{y}.

A small number of transformations (\code{\link[=stat_rule]{stat_rule()}}) are incompatible with
these aesthetics but will accept \code{aes_coord()} without warning.
}

\section{Computed variables}{
 These are calculated during the statistical
transformation and can be accessed with \link[ggplot2:aes_eval]{delayed evaluation}.
\describe{
\item{\code{component}}{the component of the composite plot; used internally}
}
}

\examples{
# petroleum rock base plot
p <- ggplot(rock, aes(area, shape, size = peri)) + theme_bw()
# scatterplot
p + geom_point()
# NB: Non-standard aesthetics are handled as in version > 3.5.1; see:
# https://github.com/tidyverse/ggplot2/issues/6191
# custom bag fraction, coefficient, and aesthetics
p + stat_bagplot(fraction = .4, coef = 1.5,
                 outlier_gp = list(shape = "asterisk"))
# invisible fence
p + stat_bagplot(fence = FALSE)
}
\references{
Rousseeuw PJ, Ruts I, & Tukey JW (1999) "The Bagplot: A Bivariate Boxplot".
\emph{The American Statistician}, \strong{53}(4): 382--387.
\doi{10.1080/00031305.1999.10474494}
}
\seealso{
Other stat layers: 
\code{\link{stat_center}()},
\code{\link{stat_chull}()},
\code{\link{stat_cone}()},
\code{\link{stat_depth}()},
\code{\link{stat_rule}()},
\code{\link{stat_scale}()},
\code{\link{stat_spantree}()}
}
\concept{stat layers}
