% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeomHextile.R
\name{draw_key_hextile}
\alias{draw_key_hextile}
\title{Hexagon key glyph for legends}
\usage{
draw_key_hextile(data, params, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
A grid grob.
}
\description{
Each geom has an associated function that draws the key when the geom needs
to be displayed in a legend. These functions are called \verb{draw_key_*()}, where \code{*}
stands for the name of the respective key glyph. The key glyphs can be
customized for individual geoms by providing a geom with the \code{key_glyph}
argument (see \code{\link[ggplot2:layer]{ggplot2::layer()}} or examples below.)
}
\examples{
library(ggplot2)

d <- ggplot(diamonds, aes(carat, price, linewidth = after_stat(count))) +
  scale_linewidth(trans = "log10")
d + geom_hex(colour = "black")

# key glyphs can be specified by their name
d + geom_hex(colour = "black", key_glyph = "hextile")

# key glyphs can be specified via their drawing function
d + geom_hex(colour = "black", key_glyph = draw_key_hextile)

}
\seealso{
\link[ggplot2:draw_key]{ggplot2::draw_key}, \code{\link[=geom_hextile]{geom_hextile()}}.
}
