% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatLineDensity.R, R/StatPathDensity.R,
%   R/stat_line_density.R
\docType{data}
\name{stat_line_density}
\alias{stat_line_density}
\alias{StatLineDensity}
\alias{StatPathDensity}
\alias{gglinedensity}
\alias{stat_path_density}
\title{Create a DenseLines Heatmap}
\usage{
stat_line_density(
  mapping = NULL,
  data = NULL,
  geom = "raster",
  position = "identity",
  ...,
  bins = 30,
  binwidth = NULL,
  drop = TRUE,
  orientation = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_path_density(
  mapping = NULL,
  data = NULL,
  geom = "raster",
  position = "identity",
  ...,
  bins = 30,
  binwidth = NULL,
  drop = TRUE,
  orientation = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{bins}{numeric vector giving number of bins in both vertical and
horizontal directions. Set to 30 by default.}

\item{binwidth}{Numeric vector giving bin width in both vertical and
horizontal directions. Overrides \code{bins} if both set.}

\item{drop}{if \code{TRUE} removes all cells with 0 counts.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
\code{stat_line_density()} is a 'ggplot2' statistic implementing the DenseLines
algorithm described by Moritz and Fisher (2018). \code{stat_path_density()} is to
\code{stat_line_density()} as \code{geom_path()} is to \code{geom_line()}.
}
\details{
\code{stat_line_density()} provides the \code{density} variable, which normalises
\code{count} by its sum in each column of bins with the same value
of the variable on the \code{orientation} axis. This is also provided by
\code{stat_path_density()}, but should be used with caution as the DenseLines
algorithm assumes lines are connected in order of the variable on the
\code{orientation} axis. \code{stat_path_density()} therefore defaults to
\code{aes(fill = after_stat(count))} rather than \code{after_stat(density)}.
}
\section{Aesthetics}{

\code{stat_line_density()} understands the following aesthetics
(required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{group}
}
}

\section{Computed variables}{

These are calculated by the 'stat' part of layers and can be accessed with
\link[ggplot2:aes_eval]{delayed evaluation}.
\itemize{
\item \code{after_stat(count)} \cr
number of lines in bin.
\item \code{after_stat(density)} \cr
density of lines in bin. The result of the DenseLines algorithm.
\item \code{after_stat(ncount)} \cr
count, scaled to maximum of 1.
\item \code{after_stat(ndensity)} \cr
density, scaled to a maximum of 1.
}
}

\section{Orientation}{


This geom treats each axis differently and, thus, can thus have two orientations. Often the orientation is easy to deduce from a combination of the given mappings and the types of positional scales in use. Thus, ggplot2 will by default try to guess which orientation the layer should have. Under rare circumstances, the orientation is ambiguous and guessing may fail. In that case the orientation can be specified directly using the \code{orientation} parameter, which can be either \code{"x"} or \code{"y"}. The value gives the axis that the geom should run along, \code{"x"} being the default orientation you would expect for the geom.

}

\examples{
library(ggplot2)

p <- ggplot(txhousing, aes(date, median, group = city))

p +
  stat_line_density(drop = FALSE, na.rm = TRUE)

p +
  aes(fill = after_stat(count)) +
  stat_line_density(
    aes(colour = after_stat(count)),
    geom = "point", size = 10, bins = 15, na.rm = TRUE
  ) +
  stat_line_density(
    aes(label = after_stat(ifelse(count > 25, count, NA))),
    geom = "label", size = 6, bins = 15, na.rm = TRUE
  )

ggplot(txhousing, aes(median, date, group = city)) +
  stat_line_density(
    aes(fill = after_stat(ndensity)),
    bins = 50, orientation = "y", na.rm = TRUE
  )

m <- ggplot(economics, aes(unemploy/pop, psavert, group = date < as.Date("2000-01-01")))
m + geom_path(aes(colour = after_stat(group)))
m + stat_path_density()

}
\references{
Moritz, D. & Fisher, D. (2018).
Visualizing a Million Time Series with the Density Line Chart.
arXiv preprint arXiv:1409.0473. \doi{10.48550/arxiv.1808.06019}.
}
\seealso{
\code{\link[ggplot2:geom_bin_2d]{ggplot2::stat_bin_2d()}}, \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}, \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}.
}
\keyword{datasets}
