% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inset_shape_circle.R
\name{shape_circle}
\alias{shape_circle}
\title{Circular insets}
\usage{
shape_circle(centre, radius)
}
\arguments{
\item{centre}{Coordinates of the inset centre. Ideally this should be an
\code{sfc} object (see \code{\link[sf:sfc]{sf::st_sfc()}}) including a coordinate reference system.
An \code{\link[sf:st]{sf::st_point()}} or a vector of longitude and latitude are also accepted.
If a CRS cannot be determined, WGS 84 is assumed.}

\item{radius}{Radius of the inset circle in the units of the inset's \code{crs_working}.}
}
\value{
A shape definition suitable for use with \code{\link[=configure_inset]{configure_inset()}}.
}
\description{
Circular insets
}
\examples{
library(ggplot2)
nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
make_demo <- function(...) {
  ggplot(nc) +
    geom_sf(fill = "grey95", colour = "grey85") +
    # For a filled frame, we want to interleave it between the base layer
    # (above this line) and the target layer (below the following line).
    geom_inset_frame(target.aes = list(fill = "white")) +
    geom_sf_inset(map_base = "none") +
    coord_sf_inset(inset = configure_inset(...)) +
    theme_void()
}
circle <- shape_circle(sf::st_centroid(nc[21,]), radius = 50)

make_demo(circle, scale = 3, translation = c(-200, -200))
make_demo(circle, scale = 3, translation = c(-100, -100))
make_demo(circle, scale = 3, translation = c(0, 0))
make_demo(circle, scale = 0.5, translation = c(0, 0))
}
\seealso{
\code{\link[=configure_inset]{configure_inset()}}

Other shapes: 
\code{\link{shape_rectangle}()},
\code{\link{shape_sf}()}
}
\concept{shapes}
