% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_corr.R
\name{plot_corr}
\alias{plot_corr}
\title{Plot correlations between (incomplete) variables}
\usage{
plot_corr(
  data,
  vrb = "all",
  label = FALSE,
  square = TRUE,
  diagonal = FALSE,
  rotate = FALSE,
  caption = TRUE
)
}
\arguments{
\item{data}{A dataset of class \code{data.frame}, \code{tibble}, or \code{matrix}.}

\item{vrb}{String, vector, or unquoted expression with variable name(s), default is "all".}

\item{label}{Logical indicating whether correlation values should be displayed.}

\item{square}{Logical indicating whether the plot tiles should be squares.}

\item{diagonal}{Logical indicating whether the correlation of each variable with itself should be displayed.}

\item{rotate}{Logical indicating whether the variable name labels should be rotated 90 degrees.}

\item{caption}{Logical indicating whether the figure caption should be displayed.}
}
\value{
An object of class \link[ggplot2:ggplot]{ggplot2::ggplot}.
}
\description{
Plot correlations between (incomplete) variables
}
\examples{
# plot correlations for all columns
plot_corr(mice::nhanes)

# plot correlations for specific columns by supplying a character vector
plot_corr(mice::nhanes, c("chl", "hyp"))

# plot correlations for specific columns by supplying unquoted variable names
plot_corr(mice::nhanes, c(chl, hyp))

# plot correlations for specific columns by passing an object with variable names
# from the environment, unquoted with `!!`
my_variables <- c("chl", "hyp")
plot_corr(mice::nhanes, !!my_variables)
# object with variable names must be unquoted with `!!`
try(plot_corr(mice::nhanes, my_variables))

}
