% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kkt.R
\name{kkt_check}
\alias{kkt_check}
\alias{grr_sigma2}
\alias{grr_beta0}
\title{Check of KKT Conditions for Linear Mixed Model}
\usage{
kkt_check(eta, sigma2, beta, eigenvalues, x, y, nt, lambda, tol.kkt = 0.001)

grr_sigma2(eta, sigma2, beta, eigenvalues, x, y, nt)

grr_beta0(eta, sigma2, beta, eigenvalues, x, y, nt)
}
\arguments{
\item{eta}{current estimate of the eta parameter}

\item{sigma2}{current estimate of the sigma2 parameter}

\item{beta}{current estimate of the beta parameter including the intercept.
this should be of length p+1, where p is the number of variables.}

\item{eigenvalues}{non-zero eigenvalues of the kinship matrix, or the square
of the singular values of the matrix used to construct the kinship matrix}

\item{x}{rotated x. Should be U^T X, where U is the matrix of eigenvectors
and X contains the first column of ones for the intercept. x should be a
mtrix of dimension n x (p+1). These are outputted by the constructor
functions. See \code{\link{ggmix_data_object}} for details}

\item{y}{rotated y. Should be U^T Y, where U is the matrix of eigenvectors
and Y is the response.}

\item{nt}{total number of observations}

\item{lambda}{A user supplied lambda sequence (this is the tuning parameter).
Typical usage is to have the program compute its own lambda sequence based
on nlambda and lambda.min.ratio. Supplying a value of lambda overrides
this. WARNING: use with care. Do not supply a single value for lambda (for
predictions after CV use predict() instead). Supply instead a decreasing
sequence of lambda values. glmnet relies on its warms starts for speed, and
its often faster to fit a whole path than compute a single fit.}

\item{tol.kkt}{Tolerance for determining if an entry of the subgradient is
zero}
}
\value{
returns the values of the gradient for each of the parameters
}
\description{
This function checks the KKT conditions
}
\note{
\code{grr_sigma2} and \code{grr_beta0} are functions for the gradient
  of sigma2 and beta0, respectively
}
