% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additions.R
\name{add_glassbrain}
\alias{add_glassbrain}
\title{Add glass brain to ggseg3d plot}
\usage{
add_glassbrain(
  p,
  hemisphere = c("left", "right"),
  colour = "#cecece",
  opacity = 0.3
)
}
\arguments{
\item{p}{plotly object}

\item{hemisphere}{string. hemisphere to plot ("left" or "right")}

\item{colour}{string. colour to give the glass brain}

\item{opacity}{numeric. transparency of the glass brain (0-1 float)}
}
\value{
plotly object with glass brain tri-surface mesh
}
\description{
Adds a translucent brain on top of a ggseg3d plot
to create a point of reference, particularly
important for sub-cortical plots.
}
\examples{
library(dplyr)
ggseg3d(atlas="aseg_3d") \%>\%
   add_glassbrain("left")
}
