% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aseg_3d}
\alias{aseg_3d}
\title{FreeSurfer automatic subcortical segmentation of a brain volume}
\format{
A tibble with 4 observations and a nested data.frame
\describe{
  \item{surf}{type of surface (`inflated` or `white`)}
  \item{hemi}{hemisphere (`left`` or `right`)}
  \item{data}{data.frame of necessary variables for plotting
  }

  \item{atlas}{String. atlas name}
  \item{roi}{numbered region from surface}
  \item{annot}{concatenated region name}
  \item{label}{label `hemi_annot` of the region}
  \item{mesh}{list of meshes in two lists: vb and it}
  \item{region}{name of region in full}
  \item{colour}{HEX colour of region}
}
}
\usage{
data(aseg_3d)
}
\description{
Coordinate data for the subcortical parcellations implemented
in FreeSurfer.
}
\examples{
data(aseg_3d)
}
\references{
Fischl et al., (2002). Neuron, 33:341-355
(\href{https://pubmed.ncbi.nlm.nih.gov/11832223/}{PubMed})
}
\seealso{
Other ggseg3d_atlases: 
\code{\link{dk_3d}}
}
\concept{ggseg3d_atlases}
\keyword{datasets}
