% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-doc.r, R/scale-shadow.r
\name{scale_viridis}
\alias{scale_viridis}
\alias{scale_shadowcolour_viridis_d}
\alias{scale_shadowcolour_viridis_c}
\alias{scale_shadowcolour_viridis_b}
\alias{scale_shadowcolour_ordinal}
\title{Viridis colour scales from viridisLite}
\usage{
scale_shadowcolour_viridis_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  aesthetics = "shadowcolour"
)

scale_shadowcolour_viridis_c(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = "colourbar",
  aesthetics = "shadowcolour"
)

scale_shadowcolour_viridis_b(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "shadowcolour"
)

scale_shadowcolour_ordinal(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  aesthetics = "shadowcolour"
)
}
\arguments{
\item{...}{Other arguments passed on to [discrete_scale()],
[continuous_scale()], or [binned_scale] to control name, limits, breaks,
  labels and so forth.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin, end}{The (corrected) hue in \verb{[0,1]} at which the color map
begins and ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{option}{A character string indicating the color map option to use.
Eight options are available:
\itemize{
 \item "magma" (or "A")
 \item "inferno" (or "B")
 \item "plasma" (or "C")
 \item "viridis" (or "D")
 \item "cividis" (or "E")
 \item "rocket" (or "F")
 \item "mako" (or "G")
 \item "turbo" (or "H")
}}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the `colour` and `fill` aesthetics at the
same time, via `aesthetics = c("colour", "fill")`.}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link[scales:rescale]{rescale()}} for a convenience function
to map an arbitrary range to between 0 and 1.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
}
\value{
a scale object to add to a plot.
}
\description{
The `viridis` scales provide colour maps that are perceptually uniform in both
colour and black-and-white. They are also designed to be perceived by viewers
with common forms of colour blindness. See also
<https://bids.github.io/colormap/>.
}
\examples{
library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg, shadowcolour=as.factor(gear)))
p + geom_glowpoint() + scale_shadowcolour_viridis_d() + guides(shadowcolour='none')

library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg, shadowcolour=gear))
p + geom_glowpoint() + scale_shadowcolour_viridis_c() + guides(shadowcolour='none')

library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg, shadowcolour=gear))
p + geom_glowpoint() + scale_shadowcolour_viridis_b() + guides(shadowcolour='none')

library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg, shadowcolour=as.factor(gear)))
p + geom_glowpoint() + scale_shadowcolour_ordinal() + guides(shadowcolour='none')

}
\seealso{
Other colour scales: 
\code{\link{scale_brewer}},
\code{\link{scale_colour_hue}},
\code{\link{scale_colour_steps}},
\code{\link{scale_gradient}},
\code{\link{scale_grey}}
}
\concept{colour scales}
