#' Subgroup Borders for Treemap Bar Charts
#'
#' Add borders to subgroups of a treemap bar chart generated by
#' [geom_treebar()] or [geom_treecol()].
#'
#' These functions take the same aesthetic mappings as [geom_treebar()] and
#' [geom_treecol()], and are to be used in conjunction with them, ensuring that
#' arguments like `position` match where supplied.
#'
#' @inheritParams ggplot2::geom_rect
#' @inheritParams treemapify::geom_treemap_subgroup_border
#' @returns A [ggplot2::layer()].
#' @seealso [geom_treebar()], [geom_treebar_subgroup_text()].
#' @examples
#' library(ggplot2)
#' ggplot(diamonds, aes(y = clarity, fill = color, subgroup = color, subgroup2 = cut)) +
#'   geom_treebar(position = "dodge") +
#'   geom_treebar_subgroup_border(position = "dodge", linewidth = 2)
#' @export
geom_treebar_subgroup_border <- function(
    mapping = NULL,
    data = NULL,
    stat = "count",
    position = "stack",
    na.rm = FALSE,
    show.legend = NA,
    inherit.aes = TRUE,
    fixed = NULL,
    layout = "squarified",
    start = "bottomleft",
    level = "subgroup",
    ...
) {
  ggplot2::layer(
    data = data,
    mapping = mapping,
    stat = stat,
    geom = GeomTreecolSubgroupBorder,
    position = position,
    show.legend = show.legend,
    inherit.aes = inherit.aes,
    params = list(
      na.rm = na.rm,
      fixed = fixed,
      layout = layout,
      start = start,
      level = level,
      ...
    )
  )
}

#' @rdname geom_treebar_subgroup_border
#' @export
geom_treecol_subgroup_border <- function(
    mapping = NULL,
    data = NULL,
    stat = "identity",
    position = "stack",
    na.rm = FALSE,
    show.legend = NA,
    inherit.aes = TRUE,
    fixed = NULL,
    layout = "squarified",
    start = "bottomleft",
    level = "subgroup",
    ...
    ) {
      ggplot2::layer(
        data = data,
        mapping = mapping,
        stat = stat,
        geom = GeomTreecolSubgroupBorder,
        position = position,
        show.legend = show.legend,
        inherit.aes = inherit.aes,
        params = list(
          na.rm = na.rm,
          fixed = fixed,
          layout = layout,
          start = start,
          level = level,
          ...
        )
      )
    }


#' @rdname geom_treebar_subgroup_border
#' @export
geom_treebar_subgroup2_border <- function(...) {
  geom_treebar_subgroup_border(level = "subgroup2", ...)
}

#' @rdname geom_treebar_subgroup_border
#' @export
geom_treecol_subgroup2_border <- function(...) {
  geom_treecol_subgroup_border(level = "subgroup2", ...)
}

#' @rdname geom_treebar_subgroup_border
#' @export
geom_treebar_subgroup3_border <- function(...) {
  geom_treebar_subgroup_border(level = "subgroup3", ...)
}

#' @rdname geom_treebar_subgroup_border
#' @export
geom_treecol_subgroup3_border <- function(...) {
  geom_treecol_subgroup_border(level = "subgroup3", ...)
}
