% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gifti.R
\name{readgii}
\alias{readgii}
\alias{readGIfTI}
\alias{read_gifti}
\title{Read GIFTI File}
\usage{
readgii(file)

readGIfTI(file)

read_gifti(file)
}
\arguments{
\item{file}{Name of file to read}
}
\value{
List of values
}
\description{
Reads a GIFTI File and parses the output
}
\examples{
if (have_gifti_test_data(outdir = NULL)) {
   gii_files = download_gifti_data(outdir = NULL)
   gii_list = lapply(gii_files, readgii)
   surf_files = grep("white[.]surf[.]gii", gii_files, value = TRUE)
   surfs = lapply(surf_files, surf_triangles)

   col_file = grep("white[.]shape[.]gii", gii_files, value = TRUE)
   cdata = readgii(col_file)
   cdata = cdata$data$shape
   mypal = grDevices::colorRampPalette(colors = c("blue", "black", "red"))
   n = 4
   breaks = quantile(cdata)
    ints = cut(cdata, include.lowest = TRUE, breaks = breaks)
    ints = as.integer(ints)
    stopifnot(!any(is.na(ints)))
    cols = mypal(n)[ints]
    cols = cols[surfs[[1]]$triangle]
}
\dontrun{
if (have_gifti_test_data(outdir = NULL)) {

 if (requireNamespace("rgl", quietly = TRUE)) {
    rgl::rgl.open()
    rgl::rgl.triangles(surfs[[1]]$pointset, color = cols)
    rgl::play3d(rgl::spin3d(), duration = 5)
 }
}
}

}
