% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_repos.R
\name{get_repos}
\alias{get_repos}
\title{Retrieve all repos for an organization or user}
\usage{
get_repos(owner, how_many = "all", git_pat = NULL, verbose = TRUE)
}
\arguments{
\item{owner}{the name of the organization or user to retrieve a list of repos from. E.g. fhdsl}

\item{how_many}{put the number of how many you would like returned. If all, put "all". By default will return all issues.}

\item{git_pat}{A personal access token from GitHub. Only necessary if the
repository being checked is a private repository.}

\item{verbose}{TRUE/FALSE do you want more progress messages?}
}
\value{
A data frame that contains information about the issues from the given repository
}
\description{
Given a username or organization, retrieve all the repos
}
\examples{
 \dontrun{

# First, set up your GitHub credentials using `usethis::gitcreds_set()`.
# Get a GitHub personal access token (PAT)
usethis::create_github_token()

# Give this token to `gitcreds_set()`
gitcreds::gitcreds_set()

# Now you can retrieve the repositories
repos_df <- get_repos("fhdsl")

# Alternatively, you can supply the GitHub PAT directly
# to the function to avoid doing the steps above.
repos_df <- get_repos("fhdsl", git_pat = "gh_somepersonalaccesstokenhere")
}
}
