% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emIL.R
\name{emil}
\alias{emil}
\title{Fitting binary regression model with missing responses based on Ibrahim and Lipsitz (1996)}
\usage{
emil(
  formula,
  data,
  adtnlCovforR = NULL,
  eps0 = 1e-05,
  maxit = 75,
  family = "binomial",
  method = "brglmFit"
)
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form \code{response ~ predictors}. The response should be a numeric binary variable with missing values, and predictors can be any variables. A predictor with categorical values with missing can be used in the model. See the documentation of formula for other details.}

\item{data}{an optional data frame in which to interpret the variables occurring in formula.}

\item{adtnlCovforR}{an optional list of covariates to be used to fit the logistic regression \code{logit(R) ~ response+predictors+adtnlCovforR}. \code{adtnlCovforR} has to be supplied as a vector. Default is \code{NULL}.}

\item{eps0}{arguments to be used to for the convergence criteria of the maximum likelihood computation of the joint likelihood function. The default is 1e-3.}

\item{maxit}{arguments to be used to for the maximization of the joint likelihood function. The default is 50.}

\item{family}{A character string specifying the type of model family.}

\item{method}{a method="brglmFit" or method="glm.fit" will be used for fitting model. The method="brglmFit" fits generalized linear models using bias reduction methods (Kosmidis, 2014), and other penalized maximum likelihood methods.}
}
\value{
return the generalized linear model estimates
}
\description{
This function enables users to fit generalized linear models when handling incomplete data in the response variable. The missing responses are assumed to be nonignorable. The model is fitted using a novel likelihood-based method proposed by Ibrahim and Lipsitz(1996).
}
\details{
The \code{family} parameter in the \code{emil} function allows you to specify the probability distribution and link function for the response variable in the linear model. It determines the nature of the relationship between the predictors and the response variable.
The \code{family} argument is particularly important when working with binary data, where the response variable has only two possible outcomes. In such cases, you typically want to fit a binary regression model with an appropriate link.

Currently the package only supports family=binomial for binary or dichotomous response variables.

You can also specify different link functions within the family=binomial. The default link function is the logit function, which models the log-odds of success. Other available link functions include:
\itemize{
\item "probit" for the probit link function, which models the cumulative standard normal distribution.
\item "cloglog" for the complementary log-log link function, which models the complementary log-log of the survival function.
}

It is important to choose the appropriate \code{family} and \code{link} function based on the specific characteristics and assumptions of your binary data. The default "binomial" family with the logit link function is often a good starting point, but alternative link functions might be more appropriate depending on the research question and the nature of the data.
}
\examples{
# using incontinence data
fit <- emil(y~x1+x2+x3,
                   data=incontinence,
                   family=binomial,
                   method="brglmFit")
summary(fit$fit_y)

}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, Biometrika, 80, 27-38. doi:10.2307/2336755.

Ibrahim, J. G. (1990). Incomplete data in generalized linear models. Journal of the American Statistical Association 85, 765–769.

Ibrahim, J. G., and Lipsitz, S. R. (1996). Parameter Estimation from Incomplete Data in Binomial Regression when the Missing Data Mechanism is Nonignorable, Biometrics, 52, 1071–1078.

Kosmidis, I., Firth, D. (2021). Jeffreys-prior penalty, finiteness and shrinkage in binomial-response generalized linear models. Biometrika, 108, 71-82. doi:10.1093/biomet/asaa052.

Louis, T. A. (1982). Finding the observed information when using the EM algorithm. Proceedings of the Royal Statistical Society, Ser B, 44, 226-233.

Maity, A., Pradhan, V., Das U (2019). Bias reduction in logistic regression with missing responses when the missing data mechanism is nonignorable. The American Statistician, (73) 340-349.

Pradhan V, Nychka DW, Bandyopadhyay S (2025).  Addressing Missing Responses and Categorical Covariates in Binary Regression Modeling: An Integrated Framework  (to be submitted).
}
