% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{mollweide_projection}
\alias{mollweide_projection}
\title{mollweide_projection}
\usage{
mollweide_projection(latitude, longitude, meridian)
}
\arguments{
\item{latitude}{Latitude (aka declination) of points}

\item{longitude}{Longitude (aka right ascension) of points}

\item{meridian}{The x=0 center of the plot}
}
\value{
X/Y coordinates
}
\description{
Performs a cartographic mollweide projection from polar coordinates (latitude/longitude) to X-Y map coordinates
}
\details{
This function uses the "Newton-Raphson with fast convergence everywhere" algorithm. 

Latitude and longitude should be in units of radians not degrees. Latitude ranges from +/- pi/2 and longitude ranges from +/- pi.
}
\examples{
longitude <- pi / 4
latitude <- pi / 4
mollweide_projection(longitude, latitude, meridian = 0)
}
\seealso{
https://en.wikipedia.org/wiki/Talk:Mollweide_projection
}
