% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-table.R
\name{md_table}
\alias{md_table}
\title{Markdown tables (4.10 extension)}
\usage{
md_table(x, ...)
}
\arguments{
\item{x}{An \code{R} object to be formatted as a table.}

\item{...}{Arguments passed to \code{\link[knitr:kable]{knitr::kable()}}}
}
\value{
A \code{glue} vector of length one, with each element or row of \code{x}
separated by a newline.
}
\description{
Take a list of data frames or matrices and pass them to \code{\link[knitr:kable]{knitr::kable()}} to
create a glue vector containing valid markdown tables.
}
\details{
FM enables the \code{table} extension, where an additional leaf block type is
available.

A table is an arrangement of data with rows and columns, consisting of a
single header row, a delimiter row separating the header from the data, and
zero or more data rows.

Each row consists of cells containing arbitrary text, in which
\href{https://github.github.com/gfm/#inline}{inlines} are parsed, separated by
pipes (\code{|}). A leading and trailing pipe is also recommended for clarity of
reading, and if there’s otherwise parsing ambiguity. Spaces between pipes and
cell content are trimmed. Block-level elements cannot be inserted in a table.

The delimiter row consists of cells whose only content are hyphens (\code{-}), and
optionally, a leading or trailing colon (\code{:}), or both, to indicate left,
right, or center alignment respectively (see \code{align} in \code{\link[knitr:kable]{knitr::kable()}}).
}
\examples{
md_table(mtcars)
md_table(data.frame(x = LETTERS[1:3], y = 1:3), align = c("cc"))
}
\seealso{
Other leaf block functions: 
\code{\link{md_blank}()},
\code{\link{md_chunk}()},
\code{\link{md_fence}()},
\code{\link{md_heading}()},
\code{\link{md_indent}()},
\code{\link{md_label}()},
\code{\link{md_paragraph}()},
\code{\link{md_reference}()},
\code{\link{md_rule}()},
\code{\link{md_setext}()}

Other markdown extensions: 
\code{\link{md_issue}()},
\code{\link{md_strike}()}
}
\concept{leaf block functions}
\concept{markdown extensions}
