% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{as.directorVector}
\alias{as.directorVector}
\alias{as.directorVector.default}
\alias{as.directorVector.azimuth}
\alias{as.directorVector.azimuthInterval}
\title{Express a direction as a director vector}
\usage{
as.directorVector(x, ...)

\method{as.directorVector}{default}(x, ...)

\method{as.directorVector}{azimuth}(x, D = 2, ...)

\method{as.directorVector}{azimuthInterval}(x, D = 2, ...)
}
\arguments{
\item{x}{value of the direction in a certain representation}

\item{...}{extra parameters for generic functionality}

\item{D}{dimension currently used (D=2 default; otherwise D=3; other values are not accepted)}
}
\value{
A 2- or 3- column matrix which rows represents the unit
director vector of each direction specified.
}
\description{
Internal methods to express a direction (in 2D or 3D) as director
vector(s). These functions are not intended for direct use.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method

\item \code{azimuth}: method for azimuths

\item \code{azimuthInterval}: method for azimuthIntervals
}}

