% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmfamm_family.R
\name{gm}
\alias{gm}
\title{Indicate Generalized Multivariate Model}
\usage{
gm(y, outcome, ...)
}
\arguments{
\item{y}{Name of variable in data set which contains the values of the
longitudinal outcome.}

\item{outcome}{Name of variable in data set which is the factor variable
indicating which outcome the value is from. Note that only the ordering
not the factor levels are used in the estimation process.}

\item{...}{Additional arguments not used at the moment.}
}
\value{
Matrix combining y and outcomes of class 'matrix' and 'gm'.
}
\description{
This function is used in the formula call of a generalized multivariate
functional additive mixed model to supply the information of the outcome and
factor variables to bamlss.
}
\examples{
set.seed(123)
# Number of subjects
n <- 10

# Number of observations
ni <- 3

# Covariate vector
x <- rep(rnorm(n), each = ni)
t <- rep(c(0, 0.5, 1), times = n)

# Additive predictor
eta_1 <- t + 0.5*x
eta_2 <- t + 0.5*x

# Outcomes
y1 <- rnorm(n*ni, eta_1, 0.3)
y2 <- rbinom(n*ni, 1, 1/(1 + exp(-eta_2)))

# Data format
dat <- data.frame(
   id = factor(rep(seq_len(n), each = ni)),
   y = c(y1, y2),
   dim = factor(rep(c(1, 2), each = n*ni)),
   t = t,
   x = x,
   fpc = 1
)

# Specify formula
f <- list(
  gm(y, dim) ~ t + x,
  sigma1 ~ 1,
  mu2 ~ t + x,
  Lambda ~ -1 + s(id, by = fpc, bs = "re")
)

}
