% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseFromList.R
\name{chooseFromList}
\alias{chooseFromList}
\title{chooseFromList}
\usage{
chooseFromList(
  theList,
  type = "items",
  userinfo = NULL,
  addAllPattern = TRUE,
  returnBoolean = FALSE,
  multiple = TRUE,
  userinput = FALSE,
  errormessage = NULL
)
}
\arguments{
\item{theList}{list or character vector to be selected from, names can specify groups}

\item{type}{string in plural shown to user to understand what they have to choose}

\item{userinfo}{string printed to the user before choosing}

\item{addAllPattern}{boolean whether 'all' and 'Search by pattern' options are added}

\item{returnBoolean}{TRUE: returns array with dimension of theList with FALSE and TRUE,
which erases the order in which entries were selected
FALSE: returns selected entries of theList, conserving the order
in which entries were selected}

\item{multiple}{TRUE: allows to select multiple entries. FALSE: no}

\item{userinput}{string provided by the user. If not supplied, user is asked (mainly for testing)}

\item{errormessage}{string used internally to tell the user before retrying that a selection does not make sense}
}
\value{
list or character vector, either a boolean with same length as theList or only the selected items.
}
\description{
Allows the user to select single or multiple items from a list.
Entries can be selected based on individual choice, groups, regex or all.
}
\examples{

 \dontrun{
    chooseFromList(
      theList = c(Letter = "A", Letter = "B", Number = "1", Number = "2"),
      type = "characters",
      userinfo = "Please don't select B, it hurts.",
      returnBoolean = FALSE,
      multiple = TRUE)
  }

}
\author{
Oliver Richters
}
