% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{logLik.joint}
\alias{logLik.joint}
\title{Log-likelihood for joint model.}
\usage{
\method{logLik}{joint}(object, conditional = FALSE, ...)
}
\arguments{
\item{object}{a \code{joint} object.}

\item{conditional}{Logical. Should the conditional or observed data log-likelihood
be returned? See \strong{details}.}

\item{...}{additional arguments (none used).}
}
\value{
Returns an object of class \code{logLik}, a number which is the log-likelihood
of the fitted model \code{object}. This has multiple attributes: \code{df} which is the 
degrees of freedom, \code{df.residual}; the number of residual degrees of freedom;
\code{AIC} and \code{BIC} which are the Akaike or Bayes information criterion evaluated at 
either the conditional or observed log-likelihood (as requested by argument 
\code{conditional}).
}
\description{
Calculate joint log-likelihood, degrees of freedom, AIC and BIC of 
joint model fit.
}
\details{
Calculate the log-likelihood of a joint model of survival and multivariate longitudinal
data (i.e. a \code{joint} object). The argument \code{conditional} manages whether
or not the log-likelihood \emph{conditional} on the random effects, or simply
the observed data log-likelihood is returned (the default, \code{conditional = FALSE}). 

If \code{conditional = TRUE}, then the log-likelihood conditional on the random 
effects is returned. That is
\deqn{\log f(T_i, \Delta_i, Y_i|b_i;\Omega) = 
      \log f(Y_i|b_i; \Omega) + \log f(T_i, \Delta_i|b_i; \Omega) + \log f(b_i|\Omega)}
      
If \code{conditional = FALSE}, then the observed data log-likelihood is returned i.e.

\deqn{\log\int f(Y_i|b_i; \Omega)f(T_i, \Delta_i|b_i; \Omega)f(b_i|\Omega)db_i.}

Additionally, the degrees of freedom, \eqn{\nu} is given by

\deqn{\nu = \code{length(vech(D))} + \sum_{k=1}^K\{P_k + P_{\sigma_k}\} + P_s,}

where \eqn{P_k} denotes the number of coefficients estimated for the \eqn{k}th response,
and \eqn{P_{\sigma_k}} the number of dispersion parameters estimated. \eqn{P_s} denotes
the number of survival coefficients, i.e. the length of \code{c(zeta, gamma)}. Finally,
all covariance parameters are captured in \code{length(vech(D))}. 

With the degrees of freedom, we can additionally compute AIC and BIC, which are defined
in no special way; and are calculated using the observed data log-likelihood.
}
\examples{
# Bivariate simulated data (2x Gaussian)
data <- simData(n = 100,
   D = diag(c(.25, .04, .2, .02)),
   gamma = c(0.4, -0.2), theta = c(-2, .2))$data
fit <- joint(list(
    Y.1 ~ time + cont + bin + (1 + time|id),
    Y.2 ~ time + cont + bin + (1 + time|id)
  ), Surv(survtime, status) ~ cont + bin, 
  data = data, 
  family = list('gaussian', 'gaussian'))

logLik(fit)

}
\references{
Henderson R, Diggle P, Dobson A. Joint modelling of longitudinal measurements and event time
data. \emph{Biostatistics} 2000; \strong{1(4)}; 465-480.

Wulfsohn MS, Tsiatis AA. A joint model for survival and longitudinal data measured with error.
\emph{Biometrics} 1997; \strong{53(1)}; 330-339.
}
\seealso{
\code{\link{extractAIC.joint}} and \code{\link{anova.joint}}
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk})
}
