% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnomonicStochastic.R
\name{plot.gnomosBoot}
\alias{plot.gnomosBoot}
\title{Plot method for gnomosBoot class}
\usage{
\method{plot}{gnomosBoot}(
  x,
  xlab = "Gnomonic intervals",
  ylab = NULL,
  col = "lightgrey",
  boxwex = 0.25,
  dayUnits = TRUE,
  ...
)
}
\arguments{
\item{x}{an object class 'gnomosBoot'.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{col}{color for the boxplot of M value for each gnomonic intervals.}

\item{boxwex}{a scale factor to be applied to all boxes in order to make the boxes narrower or wider.}

\item{dayUnits}{TRUE by default, to show the M values in 1/day unit. FALSE to show the M values in 1/year units.}

\item{\dots}{Additional arguments to the plot method.}
}
\description{
Plot method for gnomosBoot class
}
\examples{
modelBoot <- gnomonicStochastic(nInterval = 7, eggDuration = 2, addInfo = NULL, longevity = 365,
distr = "uniform", min_fecundity = 100000, max_fecundity = 300000, niter = 1000, a_init = 2)

plot(modelBoot)
}
