% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_CaseControl_model.R
\name{interaction_CC.calc}
\alias{interaction_CC.calc}
\title{Variant-Variant interaction effects on a case control variable}
\usage{
interaction_CC.calc(
  cc,
  g1,
  g2,
  yob = rep(-1, length(cc)),
  sex = rep(-1, length(cc)),
  round_imputed = FALSE,
  dominance_terms = FALSE,
  covariates = as.data.frame(matrix(0, nrow = 0, ncol = 0))
)
}
\arguments{
\item{cc}{A numeric vector}

\item{g1}{A vector with (possibly imputed) genotype values. All entries should be larger than 0 and smaller than 2.}

\item{g2}{A vector with (possibly imputed) genotype values. All entries should be larger than 0 and smaller than 2.}

\item{yob}{A numerical vector containing year of birth. If some are unknown they should be marked as -1}

\item{sex}{A numerical vector containing sex, coded 0 for males, 1 for females and -1 for unknown}

\item{round_imputed}{A boolian variable determining whether imputed genotype values should be rounded to the nearest integer in the analysis.}

\item{dominance_terms}{A boolian variable determining whether dominance terms for the variants should be included as covariates in the analysis}

\item{covariates}{A dataframe containing any other covariates that should be used; one column per covariate}
}
\value{
A list with the interaction effect (on log-scale) and corresponding standard error, z statistic and p-value
}
\description{
This function estimates the interaction effect of a pair of genetic variant on a case-control variable
We apply a logistic regression model to estimate interaction effects.
We include a linear term for each variant seperately, coded as 0,1 and 2 for non-carriers, heterozygotes and homozygous carriers of the effect allele.
We also include an interaction term, coded as the product of the two genotype values.
Effect size and significance is based on the interaction term.
}
\examples{
g1_vec <- rbinom(100000, 2, 0.9)
g2_vec <- rbinom(100000, 2, 0.1)
cc_vec <- rbinom(100000,1,0.1 * (1.05^g1_vec) *
          (1.05^g2_vec) * (1.3 ^ (g1_vec * g2_vec)))
res <- interaction_CC.calc(cc_vec, g1_vec, g2_vec)
}
