% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{HK1}
\alias{HK1}
\title{The first Henze-Klar test statistic}
\usage{
HK1(data, a = 0)
}
\arguments{
\item{data}{a vector of positive numbers.}

\item{a}{positive tuning parameter.}
}
\value{
value of the test statistic
}
\description{
This function computes the first test statistic of the goodness-of-fit test for the inverse Gaussian family due to Henze and Klar (2002).
}
\details{
The representation of the first Henze-Klar test statistic used for computation is given by: 
\deqn{HK_{n,a}^{(1)}= \frac{\hat{\varphi}_n}{n} \sum_{j,k=1}^{n} \hat{Z}_{jk}^{-1} \left\{ 1 - (Y_j + Y_k) \left( 1 + \sqrt{\frac{\pi}{2\hat{Z}_{jk}}} \text{erfce}\left( \sqrt{\frac{\hat{Z}_{jk}}{2}} \right) \right) + \left( 1 + \frac{2}{\hat{Z}_{jk}} \right) Y_j Y_k \right\},}
with \eqn{\hat{\varphi}_n = \frac{\hat{\lambda}_n}{\hat{\mu}_n}}, where \eqn{\hat{\mu}_n,\hat{\lambda}_n} are the maximum likelihood estimators for \eqn{\mu} and \eqn{\lambda}, respectively, the parameters of the inverse Gaussian distribution. 
Furthermore \eqn{\hat{Z}_{jk} = \hat{\varphi}_n(Y_j + Y_k +a)}, where \eqn{Y_i = \frac{X_i}{\hat{\mu}_n}} for \eqn{(X_i)_{i = 1,...,n}}, a sequence of  independent observations of a nonnegative random variable \eqn{X}.
To ensure numerical stability of the implementation the exponentially scaled complementary error function \eqn{\text{erfce}(x)} is used: \eqn{\text{erfce}(x) = \exp{(x^2)}\text{erfc}(x)}, with \eqn{\text{erfc}(x) = 2\int_x^\infty \exp{(-t^2)}dt/\pi}.
The null hypothesis is rejected for large values of the test statistic \eqn{HK_{n,a}^{(1)}}.
}
\examples{
HK1(rmutil::rinvgauss(20,2,1))

}
\references{
Henze, N. and Klar, B. (2002) "Goodness-of-fit tests for the inverse Gaussian distribution based on the empirical Laplace transform", Annals of the Institute of Statistical Mathematics, 54(2):425-444. \doi{https://doi.org/10.1023/A:1022442506681}
}
