% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSchemes.R
\name{resample_param_rsmplx}
\alias{resample_param_rsmplx}
\title{Parametric resampling scheme for a parametric regression model with
resampling of covariates}
\usage{
resample_param_rsmplx(data, model)
}
\arguments{
\item{data}{\code{data.frame()} with columns x and y containing the original data}

\item{model}{\link{ParamRegrModel} to use for the resampling}
}
\value{
\code{data.frame()} with columns x and y containing the resampled data
}
\description{
Generate a new, resampled dataset of the same shape as data
following the given model. The covariates are resampled from \code{data$x} and
the response variables are drawn according to \code{model$sample_yx()}.
}
\examples{
# Create an example dataset
n <- 10
x <- cbind(runif(n), rbinom(n, 1, 0.5))
model <- NormalGLM$new()
params <- list(beta = c(2, 3), sd = 1)
y <- model$sample_yx(x, params = params)
data <- dplyr::tibble(x = x, y = y)

# Fit the model to the data
model$fit(data, params_init = params, inplace = TRUE)

# Resample from the model given data
resample_param(data, model)
}
