% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{gtm_accounts_update}
\alias{gtm_accounts_update}
\title{Updates account metadata}
\usage{
gtm_accounts_update(account_id, name = NULL, shareData = c("TRUE", "FALSE"))
}
\arguments{
\item{account_id}{Account Id}

\item{name}{Account Display Name}

\item{shareData}{Whether the account shares data anonymously with Google and others. This flag enables benchmarking by sharing your data in an anonymous form. Google will remove all identifiable information about your website, combine the data with hundreds of other anonymous sites and report aggregate trends in the benchmarking service.}
}
\description{
This enables you to update the account metadata. You can update the account name and whether or not data is shared with Google.
}
\examples{
\dontrun{

account_id <- 12345678
new_account <- gtm_accounts_update(account_id, name = "New Container Name")

}
}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/update}

Other account functions: 
\code{\link{gtm_accounts_get}()},
\code{\link{gtm_accounts_list}()}
}
\concept{account functions}
