% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-geometry-columns.R
\name{gpkg_create_geometry_columns}
\alias{gpkg_create_geometry_columns}
\alias{gpkg_add_geometry_columns}
\title{GeoPackage Geometry Columns}
\usage{
gpkg_create_geometry_columns(x)

gpkg_add_geometry_columns(
  x,
  table_name,
  column_name,
  geometry_type_name = "GEOMETRY",
  srs_id,
  z,
  m
)
}
\arguments{
\item{x}{A \emph{geopackage} object, or path to GeoPackage file.}

\item{table_name}{\emph{character}. New table name.}

\item{column_name}{\emph{character}. Geometry column name. Default \code{"geom"}}

\item{geometry_type_name}{\emph{character}. Geometry type name. Default: \code{"GEOMETRY"}}

\item{srs_id}{\emph{integer}. Spatial Reference System ID. Must be defined in \code{gpkg_spatial_ref_sys} table.}

\item{z}{\emph{integer}. Default: \code{0}}

\item{m}{\emph{integer}. Default: \code{0}}
}
\value{
\emph{integer}. \code{1} if table created or row inserted successfully, \code{0} otherwise.
}
\description{
Create \code{gpkg_geometry_columns} table to account for geometry columns within the database with \code{gpkg_create_geometry_columns()}. Register new geometry columns with \code{gpkg_add_geometry_columns()}.
}
