% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp-matrix.R
\name{lp_matrix}
\alias{lp_matrix}
\alias{lp_matrix.gam}
\title{Return the linear prediction matrix of a fitted GAM}
\usage{
lp_matrix(model, ...)

\method{lp_matrix}{gam}(model, data = NULL, ...)
}
\arguments{
\item{model}{a fitted model}

\item{...}{arguments passed to other methods and \code{predict} methods including
\code{\link[mgcv:predict.gam]{mgcv::predict.gam()}} and \code{\link[mgcv:predict.bam]{mgcv::predict.bam()}}}

\item{data}{a data frame of values at which to return the linear prediction
matrix.}
}
\value{
The linear prediction matrix is returned as a matrix. The object
returned is of class \code{"lp_matrix"}, which inherits from classes \code{"matrix"}
and \code{"array"}. The special class allows the printing of the matrix to be
controlled, which we do by printing the matrix as a tibble.
}
\description{
\code{lp_matrix()} is a wrapper to \code{predict(..., type = "lpmatrix")} for returning
the linear predictor matrix for the model training data (when \code{data = NULL}),
or user-specified data values supplied via \code{data}.
}
\details{
The linear prediction matrix \eqn{\mathbf{X}_p} is a matrix that maps values
of parameters \eqn{\hat{\mathbf{\beta}}_p} to values on the linear
predictor of the model \eqn{\hat{\eta}_p = \mathbf{X}_p
\hat{\mathbf{\beta}}_p}. \eqn{\mathbf{X}_p} is the model matrix where spline
covariates have been replaced by the values of the basis functions evaluated
at the respective covariates. Parametric covariates are also included.
}
\examples{
load_mgcv()
\dontshow{
op <- options(pillar.sigfig = 3, cli.unicode = FALSE)
}
df <- data_sim("eg1", seed = 1)
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df)

# linear prediction matrix for observed data
xp <- lp_matrix(m)
## IGNORE_RDIFF_BEGIN
xp
## IGNORE_RDIFF_END

# the object `xp` *is* a matrix
class(xp)
# but we print like a tibble to avoid spamming the R console

# linear predictor matrix for new data set
ds <- data_slice(m, x2 = evenly(x2))
xp <- lp_matrix(m, data = ds)
## IGNORE_RDIFF_BEGIN
xp
## IGNORE_RDIFF_END
\dontshow{
options(op)
}
}
