% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/too_far.R
\name{too_far}
\alias{too_far}
\title{Exclude values that lie too far from the support of data}
\usage{
too_far(x, y, ref_1, ref_2, dist = NULL)
}
\arguments{
\item{x, y}{numeric; vector of values of the covariates to compare with
the observed data}

\item{ref_1, ref_2}{numeric; vectors of covariate values that represent the
reference against which \verb{x1 and }x2` are compared}

\item{dist}{if supplied, a numeric vector of length 1 representing the
distance from the data beyond which an observation is excluded. For
example, you want to exclude values that lie further from an observation
than 10\% of the range of the observed data, use \code{0.1}.}
}
\value{
Returns a logical vector of the same length as \code{x1}.
}
\description{
Identifies pairs of covariate values that lie too far from the original data.
The function is currently a basic wrapper around \code{\link[mgcv:exclude.too.far]{mgcv::exclude.too.far()}}.
}
