% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{browse}
\alias{browse}
\alias{browse_end}
\title{Debugging utilities}
\usage{
browse(func, ...)

browse_end(func, ...)
}
\arguments{
\item{func}{An R function to be browsed.}

\item{...}{Arguments to the function \emph{func} that is to be browsed.}
}
\value{
Returns the result of \code{func(...)}. Enters a \code{\link[=browser]{browser()}}.
}
\description{
Debug specified function \emph{func} by entering a \code{\link[=browser]{browser()}} right at the
beginning (\code{\link[=browse]{browse()}}) or end (\code{\link[=browse_end]{browse_end()}}) of the function.
}
\details{
These are convenience shorthands for R's builtin debug tools, like
\code{\link[=debugonce]{debugonce()}} and the \code{\link[=trace]{trace()}}/\code{\link[=untrace]{untrace()}} combination.
}
\section{Functions}{
\itemize{
\item \code{browse_end()}: Enter \code{\link[=browser]{browser()}} at the end of the function call to \code{func(...)}. This
only works, if the function can execute without error until its end.
Otherwise, the error will be thrown.

}}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Define a simple function for this example
my_func = function(a) { for (i in 1:5) { a = a + i }; return(a) }

# Enter a browser at the beginning of the function
browse(my_func, 0)

# Enter a browser at the end of the function. This allows us to inspect 
# the function's local variables without having to go through the whole loop.
browse_end(my_func, 0)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=browser]{browser()}}, \code{\link[=debugonce]{debugonce()}}, \code{\link[=trace]{trace()}}

\code{\link[=trace]{trace()}}
}
