% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_summary.R
\name{text_summary}
\alias{text_summary}
\title{Generates a textual summary of a group sequential design using the AHR method.}
\usage{
text_summary(x, information = FALSE, time_unit = "months")
}
\arguments{
\item{x}{A design object created by \code{\link[=gs_design_ahr]{gs_design_ahr()}} with or without \code{\link[=to_integer]{to_integer()}}.}

\item{information}{A logical value indicating whether to include statistical information in the textual summary. Default is FALSE.}

\item{time_unit}{A character string specifying the time unit used in the design. Options include "days", "weeks", "months" (default), and "years".}
}
\value{
A character string containing a paragraph that summarizes the design.
}
\description{
Generates a textual summary of a group sequential design using the AHR method.
}
\examples{
library(gsDesign)

# Text summary of a 1-sided design
x <- gs_design_ahr(info_frac = 1:3/3, test_lower = FALSE) |> to_integer()
x |> text_summary()

# Text summary of a 2-sided symmetric design
x <- gs_design_ahr(info_frac = 1:3/3,
                   upper = gs_spending_bound, lower = gs_spending_bound,
                   upar = list(sf = sfLDOF, total_spend = 0.025),
                   lpar = list(sf = sfLDOF, total_spend = 0.025),
                   binding = TRUE, h1_spending = FALSE) |> to_integer()
x |> text_summary()

# Text summary of a asymmetric 2-sided design with beta-spending and non-binding futility bound
x <- gs_design_ahr(info_frac = 1:3/3, alpha = 0.025, beta = 0.1,
                   upper = gs_spending_bound, lower = gs_spending_bound,
                   upar = list(sf = sfLDOF, total_spend = 0.025),
                   lpar = list(sf = sfHSD, total_spend = 0.1, param = -4),
                   binding = FALSE, h1_spending = TRUE) |> to_integer()
x |> text_summary()

# Text summary of a asymmetric 2-sided design with fixed non-binding futility bound
x <- gs_design_ahr(info_frac = 1:3/3, alpha = 0.025, beta = 0.1,
                   upper = gs_spending_bound, lower = gs_b,
                   upar = list(sf = sfLDOF, total_spend = 0.025),
                   test_upper = c(FALSE, TRUE, TRUE),
                   lpar = c(-1, -Inf, -Inf),
                   test_lower = c(TRUE, FALSE, FALSE),
                   binding = FALSE, h1_spending = TRUE) |> to_integer()
x |> text_summary()

# If there are >5 pieces of HRs, we provide a brief summary of HR.
gs_design_ahr(
  fail_rate = define_fail_rate(duration = c(rep(3, 5), Inf),
                               hr = c(0.9, 0.8, 0.7, 0.6, 0.5, 0.4),
                               fail_rate = log(2) / 10, dropout_rate = 0.001),
  info_frac = 1:3/3, test_lower = FALSE) |>
  text_summary()
}
