% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsbm_mcgd_parallel.R
\name{gsbm_mcgd_parallel}
\alias{gsbm_mcgd_parallel}
\title{Fit a Generalized Stochastic Block Model}
\usage{
gsbm_mcgd_parallel(
  A,
  lambda1,
  lambda2,
  epsilon = 0.1,
  maxit = 100,
  step_L = 0.01,
  step_S = 0.1,
  trace.it = FALSE,
  n_cores = detectCores(),
  save = FALSE,
  file = NULL
)
}
\arguments{
\item{A}{nxn adjacency matrix}

\item{lambda1}{regularization parameter for nuclear norm penalty (positive number)}

\item{lambda2}{regularization parameter for 2,1-norm penalty (positive number)}

\item{epsilon}{regularization parameter for the L2-norm penalty (positive number, if NULL, default method is applied)}

\item{maxit}{maximum number of iterations (positive integer, if NULL, default method is applied)}

\item{step_L}{step size for the gradient step of L parameter (positive number)}

\item{step_S}{step size for the gradient step of S parameter (positive number)}

\item{trace.it}{whether messages about convergence should be printed (boolean, if NULL, default is FALSE)}

\item{n_cores}{number of cores to parallellize on (integer number, default is set with detectCores())}

\item{save}{whether or not value of current estimates should be saved at each iteration (boolean)}

\item{file}{if save is set to TRUE, name of the folder where current estimates should be saved (character string, file saved in file/L_iter.txt at iteration iter)}
}
\value{
The estimate for the nxn matrix of probabilities of connections between nodes. It is
given as the sum of a low-rank nxn matrix L, corresponding to connections between inlier
nodes, and a column sparse nxn matrix S, corresponding to connections between outlier
nodes and the rest of the network. The matrices L and S are such that

E(A) = L - diag(L) + S + S'

where E(A) is the expectation of the adjacency matrix, diag(L) is a nxn diagonal
matrix with diagonal entries equal to those of L, and S' means S transposed.

The return value is a list of components
  \itemize{
  \item{\code{A}}{ the adjacency matrix.}
  \item{\code{L}}{ estimate for the low-rank component.}
  \item{\code{S}}{ estimate for the column-sparse component.}
  \item{\code{objective}}{ the value of the objective function.}
  \item{\code{R}}{ a bound on the nuclear norm of the low-rank component.}
  \item{\code{iter}}{ number of iterations between convergence of the objective function.}
 }
}
\description{
Given an adjacency matrix with missing observations, the function \code{gsbm_mgcd}
robustly estimates the probabilities of connections between nodes.
}
