% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gscaLCR.R
\name{gscaLCR}
\alias{gscaLCR}
\title{The 2nd and 3rd step of gscaLCA, which are the partitioning and fitting regression}
\usage{
gscaLCR(results.obj, covnames, multinomial.ref = "MAX")
}
\arguments{
\item{results.obj}{the results of gscaLCA.}

\item{covnames}{A character vector of covariates. The covariates are used when latent class regression (LCR) is fitted.}

\item{multinomial.ref}{A character element. Options of \code{MAX}, \code{MIX}, \code{FIRST}, and \code{LAST} are available for setting a reference group. The default is \code{MAX}.}
}
\value{
Results of the gscaLCR, fitting regression after partioning in addtion to gscaLCA results.
}
\description{
The 2nd and 3rd step of gscaLCA, which are the partitioning and fitting regression in the latent class regression.
}
\examples{
R2 = gscaLCA (dat = AddHealth[1:500, ], # Data has to include the possible covarite to run gscaLCR
               varnames = names(AddHealth)[2:6],
               ID.var = "AID",
               num.class = 3,
               num.factor = "EACH",
               Boot.num = 0,
               multiple.Core = F)

R2.gender = gscaLCR (R2, covnames = "Gender")
summary(R2.gender,  "multinomial.hard") # hard partitioning with multinomial regression
summary(R2.gender,  "multinomial.soft") # soft partitioning with multinomial regression
summary(R2.gender,  "binomial.hard")    # hard partitioning with binomial regression
summary(R2.gender,  "binomial.soft")    # soft partitioning with binomial regression

}
