% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_reppop.R
\name{check_reppop}
\alias{check_reppop}
\title{check that the RepPop is formatted correctly}
\usage{
check_reppop(reppop, request_idx)
}
\arguments{
\item{reppop}{a tibble with the information used to define how individuals among groups combine to form
hybrids. It must consist of the columns (index, pop, group).}

\item{request_idx}{The index of the request}
}
\value{
This function will return an error message if reppop is not formatted properly. If no issues exist,
a message will be returned stating that the reppop is formatted properly.
}
\description{
The input 'RepPop' is used in the segregate() function to create admixed individuals based on defined pedigrees (GSP).
In order for segregate() to work, the RepPop defined by the user must be formatted correctly. The function check_repop()
checks the RepPop for errors that would result in errors while using segregate(). Specifically, it checks that you have
three columns with the names ('index','pop', and 'group'), that the class of each column is correct, and that your indices
(column 'index') starts with 1 and all other indices are in consecutive order.
}
\keyword{internal}
