% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plink_map2rec_rates.R
\name{plink_map2rec_rates}
\alias{plink_map2rec_rates}
\title{Convert a PLINK map file to 'gscramble' RecRates bins in a tibble}
\usage{
plink_map2rec_rates(
  map,
  use_morgans = FALSE,
  cM_per_Mb = 1,
  chrom_lengths = NULL
)
}
\arguments{
\item{map}{path to the plink \code{.map} file holding information about
the markers.  This file can be gzipped.}

\item{use_morgans}{logical. IF true, the third column in the PLINK map
file (assumed to have the position of the markers in Morgans) will be used
to calculate the \code{rec_probs} in the bins of the RecRates object.}

\item{cM_per_Mb}{numeric. If \code{use_morgans} is \code{FALSE}, physical positions
will be converted to recombination fractions as \code{cM_per_Mb} centiMorgans
per megabase.  Default is 1. This is also used to determine the recombination
probability on the last segment of the chromosome (beyond the last marker)
if \code{chrom_lengths} is used.}

\item{chrom_lengths}{if you know the full length of each chromosome, you can
add those in a tibble with columns \code{chrom} and \code{bp} where \code{chrom}
\emph{must be a character vector} (Don't leave them in as numerics) and \code{bp}
must be a numeric vector of the number of base pairs of length of each
chromosome.}
}
\value{
A tibble that provides the recombination rates for the segments of the genome.
}
\description{
This is a convenience function to convert PLINK map format to
the format used in the 'gscramble' \code{RecRates} object.  By default,
this function will use the positions of the markers and assume
recombination rates of 1 cM per megabase.  If the marker positions
are also available in Morgans in the PLINK map file, the these can be
used by setting \code{use_morgans} to TRUE.
}
\details{
For simplicity, this function will assume that the length of the chromosome
is just one base pair beyond the last marker.  That is typically not correct
but will have no effect, since there are no markers to be typed out beyond
that point.  However, if you know the lengths of the chromosomes and want to
add those in there, then pass them into the \code{chrom_lengths} option.
}
\examples{
mapfile <- system.file(
    "extdata/example-plink-with-morgans.map.gz",
    package = "gscramble"
 )

# get a rec-rates tibble from the positions of the markers,
# assuming 1 cM per megabase.
rec_rates_from_positions <- plink_map2rec_rates(mapfile)

# get a rec-rates tibble from the positions of the markers,
# assuming 1.5 cM per megabase.
rec_rates_from_positions_1.5 <- plink_map2rec_rates(
    mapfile,
    cM_per_Mb = 1.5
)

# get a rec-rates tibble from the cumulative Morgans position
# in the plink map file
rec_rates_from_positions_Morg <- plink_map2rec_rates(
    mapfile,
    use_morgans = TRUE
)

# get a rec-rates tibble from the cumulative Morgans position
# in the plink map file, and extend it out to the full length
# of the chromosome (assuming for that last part of the chromosome
# a map of 1.2 cM per megabase.)
rec_rates_from_positions_Morg_fl <- plink_map2rec_rates(
    mapfile,
    use_morgans = TRUE,
    cM_per_Mb = 1.2,
    chrom_lengths = example_chrom_lengths
)
}
