% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkMeta_to_blSpecs.R
\name{rkMeta_to_blSpecs}
\alias{rkMeta_to_blSpecs}
\title{Convert reconciliation metadata}
\usage{
rkMeta_to_blSpecs(
  metadata_df,
  alterability_df = NULL,
  alterSeries = 1, 
  alterTotal1 = 0,
  alterTotal2 = 0,
  alterability_df_only = FALSE
)
}
\arguments{
\item{metadata_df}{(mandatory)

Data frame (object of class "data.frame") that describes the cross-sectional aggregation constraints
(additivity rules) for the raking problem. Two character variables must be included in the metadata data frame:
\code{series} and \code{total1}. Two variables are optional: \code{total2} (character) and \code{alterAnnual} (numeric). The values
of variable \code{series} represent the variable names of the component series in the input time series data frame
(argument \code{data_df}). Similarly, the values of variables \code{total1} and \code{total2} represent the variable names of
the 1\if{html}{\out{<sup>}}st\if{html}{\out{</sup>}} and 2\if{html}{\out{<sup>}}nd\if{html}{\out{</sup>}} dimension cross-sectional control totals in the input time series data
frame. Variable \code{alterAnnual} contains the alterability coefficient for the temporal constraint associated to
each component series. When specified, the latter will override the default alterability coefficient specified
with argument \code{alterAnnual}.}

\item{alterability_df}{(optional)

Data frame (object of class "data.frame"), or \code{NULL}, that contains the alterability coefficients variables.
They must correspond to a component series or a cross-sectional control total, that is, a variable with the same
name must exist in the input time series data frame (argument \code{data_df}). The values of these alterability
coefficients will override the default alterability coefficients specified with arguments \code{alterSeries},
\code{alterTotal1} and \code{alterTotal2}. When the input time series data frame contains several observations and the
alterability coefficients data frame contains only one, the alterability coefficients are used (repeated) for
all observations of the input time series data frame. Alternatively, the alterability coefficients data frame
may contain as many observations as the input time series data frame.

\strong{Default value} is \code{alterability_df = NULL} (default alterability coefficients).}

\item{alterSeries}{(optional)

Nonnegative real number specifying the default alterability coefficient for the component series values. It
will apply to component series for which alterability coefficients have not already been specified in the
alterability coefficients data frame (argument \code{alterability_df}).

\strong{Default value} is \code{alterSeries = 1.0} (nonbinding component series values).}

\item{alterTotal1}{(optional)

Nonnegative real number specifying the default alterability coefficient for the 1\if{html}{\out{<sup>}}st\if{html}{\out{</sup>}} dimension
cross-sectional control totals. It will apply to cross-sectional control totals for which alterability
coefficients have not already been specified in the alterability coefficients data frame (argument
\code{alterability_df}).

\strong{Default value} is \code{alterTotal1 = 0.0} (binding 1\if{html}{\out{<sup>}}st\if{html}{\out{</sup>}} dimension cross-sectional control totals)}

\item{alterTotal2}{(optional)

Nonnegative real number specifying the default alterability coefficient for the 2\if{html}{\out{<sup>}}nd\if{html}{\out{</sup>}} dimension
cross-sectional control totals. It will apply to cross-sectional control totals for which alterability
coefficients have not already been specified in the alterability coefficients data frame (argument
\code{alterability_df}).

\strong{Default value} is \code{alterTotal2 = 0.0} (binding 2\if{html}{\out{<sup>}}nd\if{html}{\out{</sup>}} dimension cross-sectional control totals).}

\item{alterability_df_only}{(optional)

Logical argument specifying whether or not only the set of alterability ceofficients found in the alterability
file (argument \code{alterability_df}) should be included in the returned \code{\link[=tsbalancing]{tsbalancing()}} problem specs data frame.
When \code{alterability_df_only = FALSE} (the default), the alterability coefficients specified with arguments
\code{alterSeries}, \code{alterTotal1} and \code{alterTotal2} are combined with those found in \code{alterability_df} (the latter
coefficients overwriting the former) and the returned data frame therefore contains alterability coefficients
for all component and cross-sectional control total series. This argument does not affect the set of temporal
total alterability coefficients (associated to \code{\link[=tsraking]{tsraking()}} argument \code{alterAnnual}) that are included in the
returned \code{\link[=tsbalancing]{tsbalancing()}} problem specs data frame. The latter always strictly contains those specified in
\code{metadata_df} with a non-missing (non-\code{NA}) value for column \code{alterAnnual}.

\strong{Default value} is \code{alterability_df_only = FALSE}.}
}
\value{
A \code{\link[=tsbalancing]{tsbalancing()}} problem specs data frame (argument \code{problem_specs_df}).
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/rkMeta_to_blSpecs.html}})}

Convert a \code{\link[=tsraking]{tsraking()}} metadata data frame to a \code{\link[=tsbalancing]{tsbalancing()}} problem specs data frame.
}
\details{
The preceding description of argument \code{alterability_df} comes from \code{\link[=tsraking]{tsraking()}}. This function
(\code{rkMeta_to_blSpecs()}) slightly changes the specification of alterability coefficients with argument
\code{alterability_df} by allowing either
\itemize{
\item a single observation, specifying the set of alterability coefficients to use for all periods,
\item or one or several observations with an additional column named \code{timeVal} allowing the specification of
both period-specific alterability coefficients (\code{timeVal} is not \code{NA}) and generic coefficients to use for
all other periods (\code{timeVal} is \code{NA}). Values for column \code{timeVal} correspond to the \emph{time values}
of a "ts" object as returned by \code{\link[stats:time]{stats::time()}}, conceptually corresponding to \eqn{year + (period - 1) / 
frequency}.
}

Another difference with \code{\link[=tsraking]{tsraking()}} is that missing (\code{NA}) values are allowed in the alterability coefficients
data frame (argument \code{alterability_df}) and result in using the generic coefficients (observations for which
\code{timeVal} is \code{NA}) or the default coefficients (arguments \code{alterSeries}, \code{alterTotal1} and \code{alterTotal2}).

Note that apart from discarding alterability coefficients for series not listed in the \code{\link[=tsraking]{tsraking()}} metadata
data frame (argument \code{metadata_df}), this function does not validate the values specified in the alterability
coefficients data frame (argument \code{alterability_df}) nor the ones specified with column \code{alterAnnual} in the
\code{\link[=tsraking]{tsraking()}} metadata data frame (argument \code{metadata_df}). The function transfers them \emph{as is} in the
returned \code{\link[=tsbalancing]{tsbalancing()}} problem specs data frame.
}
\examples{
# `tsraking()` metadata for a 2-dimensional raking problem (2 x 2 table)
my_metadata <- data.frame(series = c("A1", "A2", "B1", "B2"),
                          total1 = c("totA", "totA", "totB", "totB"),
                          total2 = c("tot1", "tot2", "tot1", "tot2"))
my_metadata


# Convert to `tsbalancing()` specifications

# Include the default `tsraking()` alterability coefficients
rkMeta_to_blSpecs(my_metadata)

# Almost binding 1st marginal totals (small alter. coef for columns `totA` and `totB`)
tail(rkMeta_to_blSpecs(my_metadata, alterTotal1 = 1e-6))

# Do not include alterability coefficients (aggregation constraints only)
rkMeta_to_blSpecs(my_metadata, alterability_df_only = TRUE)

# With an alterability coefficients file (argument `alterability_df`)
my_alter = data.frame(B2 = 0.5)
tail(rkMeta_to_blSpecs(my_metadata, alterability_df = my_alter))

# Only include the alterability coefficients from `alterability_df` 
# (i.e., for column `B2` only)
tail(rkMeta_to_blSpecs(my_metadata, alterability_df = my_alter,
                       alterability_df_only = TRUE))
}
\seealso{
\code{\link[=tsraking]{tsraking()}} \code{\link[=tsbalancing]{tsbalancing()}}
}
