% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gspcrcv.R
\name{plot.gspcrcv}
\alias{plot.gspcrcv}
\title{Plot the cross-validation solution path for the GSPCR algorithm}
\usage{
\method{plot}{gspcrcv}(
  x,
  y = NULL,
  labels = TRUE,
  errorBars = FALSE,
  discretize = TRUE,
  y_reverse = FALSE,
  print = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{gspcr}.}

\item{y}{The CV fit measure to report on the Y axis. Default is the fit measure specified in \code{cv_gspcr()}.}

\item{labels}{Logical value. \code{FALSE} hides the labels of the points indicating the number of components used. The default is \code{TRUE}.}

\item{errorBars}{Logical value. \code{TRUE} shows the error bars for each point. The default is \code{FALSE}.}

\item{discretize}{Logical value. \code{TRUE} treats the X-axis as a discrete measure that facilitates comparing solution paths between different fit measures. The default is \code{TRUE}.}

\item{y_reverse}{Logical value. \code{TRUE} reverses the y axis scale. The default is \code{FALSE}.}

\item{print}{Logical value. TRUE prints the plot when the function is called. The default is \code{TRUE}.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
A scatter plot of \code{ggplot} class
}
\description{
Produces a scatter plot showing the CV score obtained by \code{cv_gspcr} (Y-axis) with different threshold values (X-axis) for a different number of components (lines).
}
\details{
The bounds defining the error bars are computed by \code{cv_gspcr()}. First, the K-fold cross-validation score of the statistic of interest (e.g., the F score, the MSE) is computed. Then, the standard deviation of the statistic across the K folds is computed. Finally, the bounds used for the error bars are computed by summing and subtracting this standard deviation to and from the K-fold cross-validation score of the statistic.

Reversing the y-axis with \code{y_reverse} can be helpful to compare results obtained by different fit measures.
}
\author{
Edoardo Costantini, 2023
}
