% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_enthalpy_first_derivatives}
\alias{gsw_enthalpy_first_derivatives}
\title{First Derivatives of Enthalpy}
\usage{
gsw_enthalpy_first_derivatives(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{CT}{Conservative Temperature [ degC ].}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
a list containing \code{h_SA} [ (J/kg)/(g/kg) ], the derivative
of enthalpy wrt Absolute Salinity, and \code{h_CT} [ (J/kg)/degC ],
the derivative of enthalpy wrt Conservative Temperature.
}
\description{
First Derivatives of Enthalpy
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <-  c(     10,      50,     125,     250,     600,    1000)
d <- gsw_enthalpy_first_derivatives(SA, CT, p)
stopifnot(all.equal(d$h_SA, c(-0.070223912348929, -0.351159768365102, -0.887025065692568,
                              -1.829602387915694, -4.423463748270238, -7.405100077558673)))
stopifnot(all.equal(d$h_CT/1e3, c(3.991899705530481, 3.992025640520101, 3.992210365030743,
                                  3.992284150250490, 3.992685389122658, 3.993014168534175)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_enthalpy_first_derivatives.html}
}
\seealso{
Other things related to enthalpy: 
\code{\link{gsw_CT_from_enthalpy}()},
\code{\link{gsw_dynamic_enthalpy}()},
\code{\link{gsw_enthalpy}()},
\code{\link{gsw_enthalpy_CT_exact}()},
\code{\link{gsw_enthalpy_diff}()},
\code{\link{gsw_enthalpy_first_derivatives_CT_exact}()},
\code{\link{gsw_enthalpy_ice}()},
\code{\link{gsw_enthalpy_t_exact}()},
\code{\link{gsw_frazil_properties_potential}()},
\code{\link{gsw_frazil_properties_potential_poly}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice_poly}()},
\code{\link{gsw_pot_enthalpy_ice_freezing}()},
\code{\link{gsw_pot_enthalpy_ice_freezing_poly}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice_poly}()},
\code{\link{gsw_specvol_first_derivatives}()},
\code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}()}
}
\concept{things related to enthalpy}
