% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_enthalpy_t_exact}
\alias{gsw_enthalpy_t_exact}
\title{Seawater Specific Enthalpy in terms of in-situ Temperature}
\usage{
gsw_enthalpy_t_exact(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
specific enthalpy [ J/kg ]
}
\description{
Seawater Specific Enthalpy in terms of in-situ Temperature
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
t <- c( 28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
e <- gsw_enthalpy_t_exact(SA, t, p)
stopifnot(all.equal(e/1e5, c(1.151032604783763, 1.140148036012021, 0.921799209310966,
                             0.432553283808897, 0.330872159700175, 0.269705880448018)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_enthalpy_t_exact.html}
}
\seealso{
Other things related to enthalpy: 
\code{\link{gsw_CT_from_enthalpy}()},
\code{\link{gsw_dynamic_enthalpy}()},
\code{\link{gsw_enthalpy}()},
\code{\link{gsw_enthalpy_CT_exact}()},
\code{\link{gsw_enthalpy_diff}()},
\code{\link{gsw_enthalpy_first_derivatives}()},
\code{\link{gsw_enthalpy_first_derivatives_CT_exact}()},
\code{\link{gsw_enthalpy_ice}()},
\code{\link{gsw_frazil_properties_potential}()},
\code{\link{gsw_frazil_properties_potential_poly}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice_poly}()},
\code{\link{gsw_pot_enthalpy_ice_freezing}()},
\code{\link{gsw_pot_enthalpy_ice_freezing_poly}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice_poly}()},
\code{\link{gsw_specvol_first_derivatives}()},
\code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}()}
}
\concept{things related to enthalpy}
