% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ef_usa_moves_db}
\alias{ef_usa_moves_db}
\title{Emission factors from MOtor Vehicle Emission Simulator (MOVES)

Data.frame of emission factors for buses based on
values from the \href{https://www.epa.gov/moves}{MOVES3 Model}.
Estimates expressed in units 'g/km'.}
\format{
A data.table:
\describe{
\item{pollutant}{character; Pollutants: CH4 (Methane), CO (Carbon Monoxide),
CO2 (Carbon Dioxide), EC (Energy Consumption), HONO (Nitrous Acid),
N2O (Nitrous Oxide), NH3 (Ammonia),  NH4 (Ammonium), NO (Nitrogen Oxide),
NO2 (Nitrogen Dioxide), NO3 (Nitrate), NOx (Oxides of Nitrogen),
PM10 (Primary Exhaust PM10 - Total), PM25 (Primary Exhaust PM2.5 - Total),
SO2 (Sulfur Dioxide), THC (Total Gaseous Hydrocarbons ),
TOG (Total Organic Gases) and VOC (Volatile Organic Compounds)}
\item{fuel_type}{character; Type of fuel: 'D' (Diesel),'G' (Gasoline),'CNG'
(Compressed Natural Gas).}
\item{reference_year}{Numeric; Calendar Year between 2015 - 2022.
Year in which the emissions inventory is estimated.}
\item{model_year}{numeric; Model year of vehicle.}
\item{lower_speed_interval}{units 'km/h'; Represents the lower value of the
speed intervals;  The speed intervals are " - 2.5", "2.5 - 7.5", "7.5 - 12.5"
, "12.5 - 17.5", "17.5 - 22.5", "22.5 - 27.5","27.5 - 32.5","32.5 - 37.5"
,"37.5 - 42.5","42.5 - 47.5","47.5 - 52.5","52.5 - 57.5", "57.5 - 62.5"
, "62.5 - 67.5", "67.5 - 72.5", and ">72.5" mph (miles/h).}
\item{upper_speed_interval}{units in km/h; Represents the upper value of the speed intervals.
The speed intervals are analogous to \code{lower_speed_interval} above.}
\item{source_type}{character; Type of vehicle, which currently has only "Transit Bus".}
\item{id_speed}{integer;it caracterizes the types of vehicle speeds.}
}
}
\source{
\url{https://www.epa.gov/moves}
}
\usage{
ef_usa_moves_db
}
\description{
Emission factors from MOtor Vehicle Emission Simulator (MOVES)

Data.frame of emission factors for buses based on
values from the \href{https://www.epa.gov/moves}{MOVES3 Model}.
Estimates expressed in units 'g/km'.
}
\seealso{
Other emission factor data: 
\code{\link{ef_brazil_cetesb_db}},
\code{\link{ef_europe_emep_db}},
\code{\link{ef_usa_emfac_db}}
}
\concept{emission factor data}
\keyword{datasets}
