% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_gwas.R
\name{fetch_gwas}
\alias{fetch_gwas}
\title{Fetch significant GWAS associations for an EFO trait}
\usage{
fetch_gwas(efo_id = "EFO_0001663", p_cut = 5e-08)
}
\arguments{
\item{efo_id}{character. Experimental Factor Ontology (EFO) trait identifier
(e.g., "EFO_0001663").}

\item{p_cut}{numeric. P-value threshold for significance (default 5e-8).}
}
\value{
An S4 object of class \code{"associations"} with slots:
\itemize{
\item \code{associations}: data frame with \code{association_id} and \code{pvalue}.
\item \code{risk_alleles}: data frame mapping \code{association_id} to \code{variant_id}.
}
}
\description{
Tries \code{gwasrapidd::get_associations()} first; if it returns no rows
or fails, falls back to the EBI GWAS Summary Statistics REST API to
retrieve significant associations up to the given p-value threshold.
}
\details{
This function performs network calls and may be rate-limited. Column names
returned by the REST API may change; defensive checks are applied.
}
\examples{
\donttest{
  # Network call; may be rate-limited, so we mark it as \donttest.
  a <- try(fetch_gwas("EFO_0001663", p_cut = 5e-8), silent = TRUE)
  if (!inherits(a, "try-error")) {
    head(a@associations)
  }
}

}
\seealso{
\code{\link{run_gwas2crispr}}
}
