% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3-edges.R
\name{h3_edges}
\alias{h3_edges}
\alias{h3_shared_edge_sparse}
\alias{h3_shared_edge_pairwise}
\alias{is_edge}
\alias{is_valid_edge}
\alias{h3_edges_from_strings}
\alias{flatten_edges}
\alias{h3_edge_cells}
\alias{h3_edge_origin}
\alias{h3_edge_destination}
\alias{as.character.H3Edge}
\title{H3 Edges}
\usage{
h3_edges(x, flat = FALSE)

h3_shared_edge_sparse(x, y)

h3_shared_edge_pairwise(x, y)

is_edge(x)

is_valid_edge(x)

h3_edges_from_strings(x)

flatten_edges(x)

h3_edge_cells(x)

h3_edge_origin(x)

h3_edge_destination(x)

\method{as.character}{H3Edge}(x, ...)
}
\arguments{
\item{x}{an H3 vector}

\item{flat}{default \code{FALSE}. If \code{TRUE} return a single vector combining all edges of all H3 cells.}

\item{y}{an H3 vector}

\item{...}{unused.}
}
\value{
See details.
}
\description{
Functions to create or work with \code{H3Edge} vectors. See \code{Details} for further details.
}
\details{
\itemize{
\item \code{h3_edges()}: returns a list of \code{H3Edge} vectors for each H3 index.
When \code{flat = TRUE}, returns a single \code{H3Edge} vector.
\item \code{h3_shared_edge_pairwise()}: returns an \code{H3Edge} vector of shared edges. If
there is no shared edge \code{NA} is returned.
\item \code{h3_shared_edge_sparse()}: returns a list of \code{H3Edge} vectors. Each element
iterates through each element of \code{y} checking for a shared edge.
\item \code{is_edge()}: returns \code{TRUE} if the element inherits the \code{H3Edge} class.
\item \code{is_valid_edge()}: checks each element of a character vector to determine if it is
a valid edge ID.
\item \code{h3_edges_from_strings()}: create an \code{H3Edge} vector from a character vector.
\item \code{flatten_edges()}: flattens a list of \code{H3Edge} vectors into a single \code{H3Edge} vector.
\item \code{h3_edge_cells()}: returns a list of length 2 named \code{H3Edge} vectors of \code{origin} and \code{destination} cells
\item \code{h3_edge_origin()}: returns a vector of \code{H3Edge} origin cells
\item \code{h3_edge_destination()}: returns a vector of \code{H3Edge} destination cells
}
}
\examples{
# create an H3 cell
x <- h3_from_xy(-122, 38, 5)

# find all edges and flatten
edges <- h3_edges(x) |>
  flatten_edges()

# check if they are all edges
is_edge(edges)

# check if valid edge strings
is_valid_edge(c("115e22da7fffffff", "abcd"))

# get the origin cell of the edge
h3_edge_origin(edges)

# get the destination of the edge
h3_edge_destination(edges)

# get both origin and destination cells
h3_edge_cells(edges)

# create edges from strings
h3_edges_from_strings(c("115e22da7fffffff", "abcd"))

# create a vector of cells
cells_ids <-c(
  "85e22da7fffffff", "85e35ad3fffffff",
  "85e22daffffffff", "85e35adbfffffff",
  "85e22da3fffffff"
)

cells <- h3o::h3_from_strings(cells_ids)

# find shared edges between the two pairwise
h3_shared_edge_pairwise(cells, rev(cells))

# get the sparse shared eddge. Finds all possible shared edges.
h3_shared_edge_sparse(cells, cells)
}
