% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef_item}
\alias{coef_item}
\alias{coef_mean}
\alias{coef_var}
\title{Parameter Estimates from Hierarchical IRT Models.}
\usage{
coef_item(x, by_item = TRUE, digits = 3)

coef_mean(x, digits = 3)

coef_var(x, digits = 3)
}
\arguments{
\item{x}{An object of class \code{hIRT}}

\item{by_item}{Logical. Should item parameters be stored item by item
(if \code{TRUE}) or put together in a data frame (if \code{FALSE})?}

\item{digits}{The number of significant digits to use when printing}
}
\value{
Parameter estimates, standard errors, z values, and p values
  organized as a data frame (if \code{by_item = TRUE}) or a list (if \code{
  by_item = FALSE}).
}
\description{
Parameter estimates from either \code{hltm} or \code{hgrm} models. \code{code_item}
reports estimates of item parameters. \code{coef_mean} reports results for the mean equation.
\code{coef_var} reports results for the variance equation.
}
\examples{
y <- nes_econ2008[, -(1:3)]
x <- model.matrix( ~ party * educ, nes_econ2008)
z <- model.matrix( ~ party, nes_econ2008)
nes_m1 <- hgrm(y, x, z)
coef_item(nes_m1)
coef_mean(nes_m1)
coef_var(nes_m1)
}
